/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import vlcskineditor.Item;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.SliderBGGen;
import vlcskineditor.XML;
import vlcskineditor.history.ItemAddEvent;
import vlcskineditor.history.SliderBackgroundEditEvent;
import vlcskineditor.items.Slider;

public class SliderBackground
extends Item
implements ActionListener {
    public final int NBHORIZ_DEFAULT = 1;
    public final int NBVERT_DEFAULT = 1;
    public final int PADHORIZ_DEFAULT = 0;
    public final int PADVERT_DEFAULT = 0;
    public String image;
    public int nbhoriz = 1;
    public int nbvert = 1;
    public int padhoriz = 0;
    public int padvert = 0;
    JFrame frame;
    public JTextField id_tf;
    public JTextField image_tf;
    public JTextField nbhoriz_tf;
    public JTextField nbvert_tf;
    public JTextField padhoriz_tf;
    public JTextField padvert_tf;
    JButton gen_btn;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;
    BufferedImage bi = null;
    String bitmap_str = "";
    Slider sl;

    public SliderBackground(String string, Skin skin) {
        this.type = "SliderBackground";
        this.s = skin;
        this.image = XML.getValue(string, "image");
        if (string.indexOf("nbhoriz=\"") != -1) {
            this.nbhoriz = XML.getIntValue(string, "nbhoriz");
        }
        if (string.indexOf("nbvert=\"") != -1) {
            this.nbvert = XML.getIntValue(string, "nbvert");
        }
        if (string.indexOf("padhoriz=\"") != -1) {
            this.padhoriz = XML.getIntValue(string, "padhoriz");
        }
        if (string.indexOf("padvert=\"") != -1) {
            this.padvert = XML.getIntValue(string, "padvert");
        }
        this.id = string.indexOf("id=\"") != -1 ? XML.getValue(string, "id") : "Unnamed slider background #" + this.s.getNewId();
        this.created = true;
    }

    public SliderBackground(Skin skin, Slider slider) {
        this.type = "SliderBackground";
        this.s = skin;
        this.sl = slider;
        this.image = "none";
        this.id = "Unnamed slider background #" + this.s.getNewId();
        this.showOptions();
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.image = this.image_tf.getText();
            this.nbhoriz = Integer.parseInt(this.nbhoriz_tf.getText());
            this.nbvert = Integer.parseInt(this.nbvert_tf.getText());
            this.padhoriz = Integer.parseInt(this.padhoriz_tf.getText());
            this.padvert = Integer.parseInt(this.padvert_tf.getText());
            this.frame.setDefaultCloseOperation(2);
            this.created = true;
            ItemAddEvent itemAddEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(itemAddEvent);
        } else {
            SliderBackgroundEditEvent sliderBackgroundEditEvent = new SliderBackgroundEditEvent(this);
            this.id = this.id_tf.getText();
            this.image = this.image_tf.getText();
            this.nbhoriz = Integer.parseInt(this.nbhoriz_tf.getText());
            this.nbvert = Integer.parseInt(this.nbvert_tf.getText());
            this.padhoriz = Integer.parseInt(this.padhoriz_tf.getText());
            this.padvert = Integer.parseInt(this.padvert_tf.getText());
            sliderBackgroundEditEvent.setNew();
            this.s.m.hist.addEvent(sliderBackgroundEditEvent);
        }
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame("Slider background settings");
            this.frame.setResizable(false);
            this.frame.setLayout(new FlowLayout());
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel("ID*:");
            this.id_tf = new JTextField();
            this.gen_btn = new JButton("Open slider background wizard...");
            this.gen_btn.addActionListener(this);
            JLabel jLabel2 = new JLabel("Image*:");
            this.image_tf = new JTextField();
            JLabel jLabel3 = new JLabel("Horiz. Sub-images:");
            this.nbhoriz_tf = new JTextField();
            this.nbhoriz_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel4 = new JLabel("Vert. Sub-images:");
            this.nbvert_tf = new JTextField();
            this.nbvert_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel5 = new JLabel("Horiz. padding:");
            this.padhoriz_tf = new JTextField();
            this.padhoriz_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel6 = new JLabel("Vert. padding:");
            this.padvert_tf = new JTextField();
            this.padvert_tf.setDocument(new NumbersOnlyDocument());
            this.ok_btn = new JButton("OK");
            this.ok_btn.addActionListener(this);
            this.ok_btn.setPreferredSize(new Dimension(70, 25));
            this.cancel_btn = new JButton("Cancel");
            this.cancel_btn.addActionListener(this);
            this.cancel_btn.setPreferredSize(new Dimension(70, 25));
            this.help_btn = new JButton("Help");
            this.help_btn.addActionListener(this);
            this.help_btn.setPreferredSize(new Dimension(70, 25));
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            jLabel.setBounds(5, 15, 75, 24);
            this.id_tf.setBounds(85, 15, 150, 24);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "General Attributes"));
            jPanel.setMinimumSize(new Dimension(240, 45));
            jPanel.setPreferredSize(new Dimension(240, 45));
            jPanel.setMaximumSize(new Dimension(240, 45));
            this.frame.add(jPanel);
            this.frame.add(this.gen_btn);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel2);
            jPanel2.add(this.image_tf);
            jLabel2.setBounds(5, 15, 75, 24);
            this.image_tf.setBounds(85, 15, 150, 24);
            jPanel2.add(jLabel3);
            jPanel2.add(this.nbhoriz_tf);
            jLabel3.setBounds(5, 45, 75, 24);
            this.nbhoriz_tf.setBounds(85, 45, 150, 24);
            jPanel2.add(jLabel4);
            jPanel2.add(this.nbvert_tf);
            jLabel4.setBounds(5, 75, 75, 24);
            this.nbvert_tf.setBounds(85, 75, 150, 24);
            jPanel2.add(jLabel5);
            jPanel2.add(this.padhoriz_tf);
            jLabel5.setBounds(5, 105, 75, 24);
            this.padhoriz_tf.setBounds(85, 105, 150, 24);
            jPanel2.add(jLabel6);
            jPanel2.add(this.padvert_tf);
            jLabel6.setBounds(5, 135, 75, 24);
            this.padvert_tf.setBounds(85, 135, 150, 24);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Background Attributes"));
            jPanel2.setMinimumSize(new Dimension(240, 165));
            jPanel2.setPreferredSize(new Dimension(240, 165));
            jPanel2.setMaximumSize(new Dimension(240, 165));
            this.frame.add(jPanel2);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(new JLabel("* required attribute"));
            this.frame.setMinimumSize(new Dimension(250, 320));
            this.frame.setPreferredSize(new Dimension(250, 320));
            this.frame.setMaximumSize(new Dimension(250, 320));
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.image_tf.setText(this.image);
        this.nbhoriz_tf.setText(String.valueOf(this.nbhoriz));
        this.nbvert_tf.setText(String.valueOf(this.nbvert));
        this.padhoriz_tf.setText(String.valueOf(this.padhoriz));
        this.padvert_tf.setText(String.valueOf(this.padvert));
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Please enter a valid ID!", "ID not valid", 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, "The ID \"" + this.id_tf.getText() + "\" already exists, please choose another one.", "ID not valid", 1);
                return;
            }
            if (this.s.getResource(this.image_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "The bitmap \"" + this.image_tf.getText() + "\" does not exist!", "Image not valid", 1);
                return;
            }
            this.update();
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/i-sliderbg.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/i-sliderbg.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.gen_btn)) {
            SliderBGGen sliderBGGen = new SliderBGGen(this, this.s);
            sliderBGGen.setDefaultCloseOperation(2);
            sliderBGGen.setVisible(true);
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
            if (!this.created) {
                this.sl.removeBG();
            }
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<SliderBackground";
        if (!this.id.equals("Unnamed")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        string2 = string2 + " image=\"" + this.image + "\"";
        if (this.nbhoriz != 1) {
            string2 = string2 + " nbhoriz=\"" + String.valueOf(this.nbhoriz) + "\"";
        }
        if (this.nbvert != 1) {
            string2 = string2 + " nbvert=\"" + String.valueOf(this.nbvert) + "\"";
        }
        if (this.padhoriz != 0) {
            string2 = string2 + " padhoriz=\"" + String.valueOf(this.padhoriz) + "\"";
        }
        if (this.padvert != 0) {
            string2 = string2 + " padvert=\"" + String.valueOf(this.padvert) + "\"";
        }
        string2 = string2 + "/>";
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, 0, 0, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        int n4;
        if (!this.created) {
            return;
        }
        this.bi = this.s.getBitmapImage(this.image);
        if (this.bi == null) {
            return;
        }
        int n5 = (this.bi.getWidth() - this.padhoriz * (this.nbhoriz - 1)) / this.nbhoriz;
        int n6 = (this.bi.getHeight() - this.padvert * (this.nbvert - 1)) / this.nbvert;
        int n7 = this.nbhoriz * this.nbvert;
        float f = this.s.gvars.getSliderValue();
        int n8 = (int)((float)n7 * f);
        int n9 = n8 / this.nbhoriz - 1;
        if (n9 < 0) {
            n9 = 0;
        }
        if ((n4 = n8 % this.nbhoriz) < 0) {
            n4 = 0;
        }
        this.bi = this.bi.getSubimage(n4 * n5 + n4 * this.padhoriz, n9 * n6 + n9 * this.padvert, n5, n6);
        graphics2D.drawImage(this.bi, (this.x + n) * n3, (this.y + n2) * n3, this.bi.getWidth() * n3, this.bi.getHeight() * n3, null);
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect((this.x + n) * n3, (this.y + n2) * n3, this.bi.getWidth() * n3 - 1, this.bi.getHeight() * n3 - 1);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        if (this.bi == null) {
            return false;
        }
        return n >= this.x + this.offsetx && n <= this.x + this.bi.getWidth() + this.offsetx && n2 >= this.y + this.offsety && n2 <= this.y + this.bi.getHeight() + this.offsety;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("SliderBackground: " + this.id);
        return defaultMutableTreeNode;
    }

    @Override
    public boolean uses(String string) {
        return this.image.equals(string);
    }
}

