/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import vlcskineditor.ActionEditor;
import vlcskineditor.Helper;
import vlcskineditor.Item;
import vlcskineditor.Language;
import vlcskineditor.Main;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.CheckboxEditEvent;
import vlcskineditor.history.ItemAddEvent;
import vlcskineditor.resources.ImageResource;
import vlcskineditor.resources.ResourceChangeListener;
import vlcskineditor.resources.ResourceChangedEvent;

public class Checkbox
extends Item
implements ActionListener,
ResourceChangeListener {
    public final String DOWN1_DEFAULT = "none";
    public final String DOWN2_DEFAULT = "none";
    public final String OVER1_DEFAULT = "none";
    public final String OVER2_DEFAULT = "none";
    public final String ACTION1_DEFAULT = "none";
    public final String ACTION2_DEFAULT = "none";
    public final String TOOLTIPTEXT1_DEFAULT = "";
    public final String TOOLTIPTEXT2_DEFAULT = "";
    public String up1;
    public String up2;
    public String down1 = "none";
    public String down2 = "none";
    public String over1 = "none";
    public String over2 = "none";
    public String state;
    public String action1 = "none";
    public String action2 = "none";
    public String tooltiptext1 = "";
    public String tooltiptext2 = "";
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField help_tf;
    JTextField visible_tf;
    JTextField up1_tf;
    JTextField down1_tf;
    JTextField over1_tf;
    JTextField action1_tf;
    JTextField tooltiptext1_tf;
    JTextField up2_tf;
    JTextField down2_tf;
    JTextField over2_tf;
    JTextField action2_tf;
    JTextField tooltiptext2_tf;
    JTextField state_tf;
    JComboBox lefttop_cb;
    JComboBox rightbottom_cb;
    JComboBox xkeepratio_cb;
    JComboBox ykeepratio_cb;
    JButton visible_btn;
    JButton action1_btn;
    JButton action2_btn;
    JButton state_btn;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;
    ImageResource up1_res;
    ImageResource over1_res;
    ImageResource down1_res;
    ImageResource up2_res;
    ImageResource over2_res;
    ImageResource down2_res;
    ActionEditor action1_ae;
    ActionEditor action2_ae;
    private boolean state_bool = true;

    public Checkbox(Node node, Skin skin) {
        this.type = Language.get("CHECKBOX");
        this.s = skin;
        this.id = XML.getStringAttributeValue(node, "id", Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId())));
        this.state = XML.getStringAttributeValue(node, "state", this.state);
        this.up1 = XML.getStringAttributeValue(node, "up1", this.up1);
        this.over1 = XML.getStringAttributeValue(node, "over1", this.over1);
        this.down1 = XML.getStringAttributeValue(node, "down1", this.down1);
        this.action1 = XML.getStringAttributeValue(node, "action1", this.action1);
        this.tooltiptext1 = XML.getStringAttributeValue(node, "tooltiptext1", this.tooltiptext1);
        this.up2 = XML.getStringAttributeValue(node, "up2", this.up2);
        this.over2 = XML.getStringAttributeValue(node, "over2", this.over2);
        this.down2 = XML.getStringAttributeValue(node, "down2", this.down2);
        this.action2 = XML.getStringAttributeValue(node, "action2", this.action2);
        this.tooltiptext2 = XML.getStringAttributeValue(node, "tooltiptext2", this.tooltiptext2);
        this.x = XML.getIntAttributeValue(node, "x", this.x);
        this.y = XML.getIntAttributeValue(node, "y", this.y);
        this.lefttop = XML.getStringAttributeValue(node, "lefttop", this.lefttop);
        this.rightbottom = XML.getStringAttributeValue(node, "rightbottom", this.rightbottom);
        this.xkeepratio = XML.getBoolAttributeValue(node, "xkeepratio", this.xkeepratio);
        this.ykeepratio = XML.getBoolAttributeValue(node, "ykeepratio", this.ykeepratio);
        this.visible = XML.getStringAttributeValue(node, "visible", this.visible);
        this.help = XML.getStringAttributeValue(node, "help", this.help);
        this.created = true;
        this.up1_res = this.s.getImageResource(this.up1);
        if (this.up1_res != null) {
            this.up1_res.addResourceChangeListener(this);
        }
        this.over1_res = this.s.getImageResource(this.over1);
        if (this.over1_res != null) {
            this.over1_res.addResourceChangeListener(this);
        }
        this.down1_res = this.s.getImageResource(this.down1);
        if (this.down1_res != null) {
            this.down1_res.addResourceChangeListener(this);
        }
        this.up2_res = this.s.getImageResource(this.up2);
        if (this.up2_res != null) {
            this.up2_res.addResourceChangeListener(this);
        }
        this.over2_res = this.s.getImageResource(this.over2);
        if (this.over2_res != null) {
            this.over2_res.addResourceChangeListener(this);
        }
        this.down2_res = this.s.getImageResource(this.down2);
        if (this.down2_res != null) {
            this.down2_res.addResourceChangeListener(this);
        }
        this.updateToGlobalVariables();
    }

    public Checkbox(Skin skin) {
        this.type = Language.get("CHECKBOX");
        this.s = skin;
        this.up1 = "none";
        this.up2 = "none";
        this.state = "false";
        this.id = Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        this.showOptions();
    }

    public Checkbox(Checkbox checkbox) {
        super(checkbox);
        this.type = Language.get("CHECKBOX");
        this.state = checkbox.state;
        this.up1 = checkbox.up1;
        this.down1 = checkbox.down1;
        this.over1 = checkbox.over1;
        this.action1 = checkbox.action1;
        this.tooltiptext1 = checkbox.tooltiptext1;
        this.up2 = checkbox.up2;
        this.down2 = checkbox.down2;
        this.over2 = checkbox.over2;
        this.action2 = checkbox.action2;
        this.tooltiptext2 = checkbox.tooltiptext2;
        this.up1_res = this.s.getImageResource(this.up1);
        if (this.up1_res != null) {
            this.up1_res.addResourceChangeListener(this);
        }
        this.over1_res = this.s.getImageResource(this.over1);
        if (this.over1_res != null) {
            this.over1_res.addResourceChangeListener(this);
        }
        this.down1_res = this.s.getImageResource(this.down1);
        if (this.down1_res != null) {
            this.down1_res.addResourceChangeListener(this);
        }
        this.up2_res = this.s.getImageResource(this.up2);
        if (this.up2_res != null) {
            this.up2_res.addResourceChangeListener(this);
        }
        this.over2_res = this.s.getImageResource(this.over2);
        if (this.over2_res != null) {
            this.over2_res.addResourceChangeListener(this);
        }
        this.down2_res = this.s.getImageResource(this.down2);
        if (this.down2_res != null) {
            this.down2_res.addResourceChangeListener(this);
        }
        this.updateToGlobalVariables();
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.up1 = this.up1_tf.getText();
            this.over1 = this.over1_tf.getText();
            this.down1 = this.down1_tf.getText();
            this.action1 = this.action1_tf.getText();
            this.tooltiptext1 = this.tooltiptext1_tf.getText();
            this.up2 = this.up2_tf.getText();
            this.over2 = this.over2_tf.getText();
            this.down2 = this.down2_tf.getText();
            this.action2 = this.action2_tf.getText();
            this.tooltiptext2 = this.tooltiptext2_tf.getText();
            this.state = this.state_tf.getText();
            ItemAddEvent itemAddEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(itemAddEvent);
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.frame.setDefaultCloseOperation(2);
            this.created = true;
        } else {
            CheckboxEditEvent checkboxEditEvent = new CheckboxEditEvent(this);
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.up1 = this.up1_tf.getText();
            this.over1 = this.over1_tf.getText();
            this.down1 = this.down1_tf.getText();
            this.action1 = this.action1_tf.getText();
            this.tooltiptext1 = this.tooltiptext1_tf.getText();
            this.up2 = this.up2_tf.getText();
            this.over2 = this.over2_tf.getText();
            this.down2 = this.down2_tf.getText();
            this.action2 = this.action2_tf.getText();
            this.tooltiptext2 = this.tooltiptext2_tf.getText();
            this.state = this.state_tf.getText();
            checkboxEditEvent.setNew();
            this.s.m.hist.addEvent(checkboxEditEvent);
            this.s.updateItems();
            this.s.expandItem(this.id);
        }
        this.updateToGlobalVariables();
        if (this.up1_res != null) {
            this.up1_res.addResourceChangeListener(this);
        }
        if (this.over1_res != null) {
            this.over1_res.addResourceChangeListener(this);
        }
        if (this.down1_res != null) {
            this.down1_res.addResourceChangeListener(this);
        }
        if (this.up2_res != null) {
            this.up2_res.addResourceChangeListener(this);
        }
        if (this.over2_res != null) {
            this.over2_res.addResourceChangeListener(this);
        }
        if (this.down2_res != null) {
            this.down2_res.addResourceChangeListener(this);
        }
    }

    @Override
    public void showOptions() {
        if (this.up1_res != null) {
            this.up1_res.removeResourceChangeListener(this);
        }
        if (this.over1_res != null) {
            this.over1_res.removeResourceChangeListener(this);
        }
        if (this.down1_res != null) {
            this.down1_res.removeResourceChangeListener(this);
        }
        if (this.up2_res != null) {
            this.up2_res.removeResourceChangeListener(this);
        }
        if (this.over2_res != null) {
            this.over2_res.removeResourceChangeListener(this);
        }
        if (this.down2_res != null) {
            this.down2_res.removeResourceChangeListener(this);
        }
        if (this.frame == null) {
            this.frame = new JFrame(Language.get("WIN_CHECKBOX_TITLE"));
            this.frame.setIconImage(Main.edit_icon.getImage());
            this.frame.setResizable(false);
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel(Language.get("WIN_ITEM_ID"));
            this.id_tf = new JTextField();
            JLabel jLabel2 = new JLabel(Language.get("WIN_ITEM_X"));
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel(Language.get("WIN_ITEM_Y"));
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument());
            String[] stringArray = new String[]{"lefttop", "leftbottom", "righttop", "rightbottom"};
            JLabel jLabel4 = new JLabel(Language.get("WIN_ITEM_LEFTTOP"));
            this.lefttop_cb = new JComboBox<String>(stringArray);
            this.lefttop_cb.setToolTipText(Language.get("WIN_ITEM_LEFTTOP_TIP"));
            JLabel jLabel5 = new JLabel(Language.get("WIN_ITEM_RIGHTBOTTOM"));
            this.rightbottom_cb = new JComboBox<String>(stringArray);
            this.rightbottom_cb.setToolTipText(Language.get("WIN_ITEM_RIGHTBOTTOM_TIP"));
            Object[] objectArray = new Object[]{true, false};
            JLabel jLabel6 = new JLabel(Language.get("WIN_ITEM_XKEEPRATIO"));
            this.xkeepratio_cb = new JComboBox<Object>(objectArray);
            this.xkeepratio_cb.setToolTipText(Language.get("WIN_ITEM_XKEEPRATIO_TIP"));
            JLabel jLabel7 = new JLabel(Language.get("WIN_ITEM_YKEEPRATIO"));
            this.ykeepratio_cb = new JComboBox<Object>(objectArray);
            this.ykeepratio_cb.setToolTipText(Language.get("WIN_ITEM_YKEEPRATIO_TIP"));
            JLabel jLabel8 = new JLabel(Language.get("WIN_ITEM_VISIBLE"));
            this.visible_tf = new JTextField();
            this.visible_btn = new JButton("", Main.help_icon);
            this.visible_btn.addActionListener(this);
            JLabel jLabel9 = new JLabel(Language.get("WIN_ITEM_HELP"));
            this.help_tf = new JTextField();
            this.help_tf.setToolTipText(Language.get("WIN_ITEM_HELP_TIP"));
            JLabel jLabel10 = new JLabel(Language.get("WIN_CHECKBOX_UP"));
            this.up1_tf = new JTextField();
            JLabel jLabel11 = new JLabel(Language.get("WIN_CHECKBOX_OVER"));
            this.over1_tf = new JTextField();
            JLabel jLabel12 = new JLabel(Language.get("WIN_CHECKBOX_DOWN"));
            this.down1_tf = new JTextField();
            JLabel jLabel13 = new JLabel(Language.get("WIN_CHECKBOX_ACTION"));
            this.action1_tf = new JTextField();
            this.action1_btn = new JButton("", Main.editor_icon);
            this.action1_btn.addActionListener(this);
            JLabel jLabel14 = new JLabel(Language.get("WIN_ITEM_TOOLTIPTEXT"));
            this.tooltiptext1_tf = new JTextField();
            JLabel jLabel15 = new JLabel(Language.get("WIN_CHECKBOX_UP"));
            this.up2_tf = new JTextField();
            JLabel jLabel16 = new JLabel(Language.get("WIN_CHECKBOX_OVER"));
            this.over2_tf = new JTextField();
            JLabel jLabel17 = new JLabel(Language.get("WIN_CHECKBOX_DOWN"));
            this.down2_tf = new JTextField();
            JLabel jLabel18 = new JLabel(Language.get("WIN_CHECKBOX_ACTION"));
            this.action2_tf = new JTextField();
            this.action2_btn = new JButton("", Main.editor_icon);
            this.action2_btn.addActionListener(this);
            JLabel jLabel19 = new JLabel(Language.get("WIN_ITEM_TOOLTIPTEXT"));
            this.tooltiptext2_tf = new JTextField();
            JLabel jLabel20 = new JLabel(Language.get("WIN_CHECKBOX_CONDITION"));
            this.state_tf = new JTextField();
            this.state_tf.setToolTipText(Language.get("WIN_CHECKBOX_CONDITION_TIP"));
            this.state_btn = new JButton("", Main.help_icon);
            this.state_btn.addActionListener(this);
            this.ok_btn = new JButton(Language.get("BUTTON_OK"));
            this.ok_btn.addActionListener(this);
            this.cancel_btn = new JButton(Language.get("BUTTON_CANCEL"));
            this.cancel_btn.addActionListener(this);
            this.help_btn = new JButton(Language.get("BUTTON_HELP"));
            this.help_btn.addActionListener(this);
            JLabel jLabel21 = new JLabel(Language.get("NOTE_STARRED"));
            Component[] componentArray = new Component[]{jLabel, jLabel2, jLabel3, jLabel4, jLabel5, jLabel6, jLabel7, jLabel8, jLabel9, jLabel20};
            int n = Helper.maxWidth(componentArray) + 10;
            int n2 = 200;
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            this.id_tf.setPreferredSize(new Dimension(n2, this.id_tf.getPreferredSize().height));
            jPanel.add(jLabel2);
            jPanel.add(this.x_tf);
            jPanel.add(jLabel3);
            jPanel.add(this.y_tf);
            jPanel.add(jLabel4);
            jPanel.add(this.lefttop_cb);
            jPanel.add(jLabel5);
            jPanel.add(this.rightbottom_cb);
            jPanel.add(jLabel6);
            jPanel.add(this.xkeepratio_cb);
            jPanel.add(jLabel7);
            jPanel.add(this.ykeepratio_cb);
            jPanel.add(jLabel8);
            jPanel.add(this.visible_tf);
            jPanel.add(this.visible_btn);
            jPanel.add(jLabel9);
            jPanel.add(this.help_tf);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_ITEM_GENERAL")));
            SpringLayout springLayout = new SpringLayout();
            jPanel.setLayout(springLayout);
            springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)jPanel);
            springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.id_tf, 0, "VerticalCenter", (Component)jLabel);
            springLayout.putConstraint("West", (Component)this.id_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("North", (Component)jLabel2, 10, "South", (Component)this.id_tf);
            springLayout.putConstraint("West", (Component)jLabel2, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.x_tf, 0, "VerticalCenter", (Component)jLabel2);
            springLayout.putConstraint("West", (Component)this.x_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.x_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel3, 10, "South", (Component)this.x_tf);
            springLayout.putConstraint("West", (Component)jLabel3, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.y_tf, 0, "VerticalCenter", (Component)jLabel3);
            springLayout.putConstraint("West", (Component)this.y_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.y_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel4, 10, "South", (Component)this.y_tf);
            springLayout.putConstraint("West", (Component)jLabel4, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.lefttop_cb, 0, "VerticalCenter", (Component)jLabel4);
            springLayout.putConstraint("West", (Component)this.lefttop_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.lefttop_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel5, 10, "South", (Component)this.lefttop_cb);
            springLayout.putConstraint("West", (Component)jLabel5, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.rightbottom_cb, 0, "VerticalCenter", (Component)jLabel5);
            springLayout.putConstraint("West", (Component)this.rightbottom_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.rightbottom_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel6, 10, "South", (Component)this.rightbottom_cb);
            springLayout.putConstraint("West", (Component)jLabel6, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.xkeepratio_cb, 0, "VerticalCenter", (Component)jLabel6);
            springLayout.putConstraint("West", (Component)this.xkeepratio_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.xkeepratio_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel7, 10, "South", (Component)this.xkeepratio_cb);
            springLayout.putConstraint("West", (Component)jLabel7, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.ykeepratio_cb, 0, "VerticalCenter", (Component)jLabel7);
            springLayout.putConstraint("West", (Component)this.ykeepratio_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.ykeepratio_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel8, 10, "South", (Component)this.ykeepratio_cb);
            springLayout.putConstraint("West", (Component)jLabel8, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.visible_tf, 0, "VerticalCenter", (Component)jLabel8);
            springLayout.putConstraint("West", (Component)this.visible_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.visible_tf, -5, "West", (Component)this.visible_btn);
            springLayout.putConstraint("VerticalCenter", (Component)this.visible_btn, 0, "VerticalCenter", (Component)jLabel8);
            springLayout.putConstraint("East", (Component)this.visible_btn, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel9, 10, "South", (Component)this.visible_btn);
            springLayout.putConstraint("West", (Component)jLabel9, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.help_tf, 0, "VerticalCenter", (Component)jLabel9);
            springLayout.putConstraint("West", (Component)this.help_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.help_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("East", (Component)jPanel, 5, "East", (Component)this.id_tf);
            springLayout.putConstraint("South", (Component)jPanel, 10, "South", (Component)this.help_tf);
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel20);
            jPanel2.add(this.state_tf);
            jPanel2.add(this.state_btn);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_CHECKBOX_STATE")));
            SpringLayout springLayout2 = new SpringLayout();
            jPanel2.setLayout(springLayout2);
            springLayout2.putConstraint("North", (Component)jLabel20, 5, "North", (Component)jPanel2);
            springLayout2.putConstraint("West", (Component)jLabel20, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.state_tf, 0, "VerticalCenter", (Component)jLabel20);
            springLayout2.putConstraint("West", (Component)this.state_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.state_btn, 0, "VerticalCenter", (Component)jLabel20);
            springLayout2.putConstraint("West", (Component)this.state_btn, 5, "East", (Component)this.state_tf);
            springLayout2.putConstraint("East", (Component)jPanel2, 5, "East", (Component)this.state_btn);
            springLayout2.putConstraint("South", (Component)jPanel2, 10, "South", (Component)this.state_tf);
            this.frame.add(jPanel2);
            Component[] componentArray2 = new Component[]{jLabel10, jLabel11, jLabel12, jLabel13, jLabel14};
            n = Helper.maxWidth(componentArray2) + 10;
            JPanel jPanel3 = new JPanel(null);
            jPanel3.add(jLabel10);
            jPanel3.add(this.up1_tf);
            this.up1_tf.setPreferredSize(new Dimension(n2, this.up1_tf.getPreferredSize().height));
            jPanel3.add(jLabel11);
            jPanel3.add(this.over1_tf);
            jPanel3.add(jLabel12);
            jPanel3.add(this.down1_tf);
            jPanel3.add(jLabel13);
            jPanel3.add(this.action1_tf);
            jPanel3.add(this.action1_btn);
            jPanel3.add(jLabel14);
            jPanel3.add(this.tooltiptext1_tf);
            jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_CHECKBOX_STATE1")));
            SpringLayout springLayout3 = new SpringLayout();
            springLayout3.putConstraint("North", (Component)jLabel10, 5, "North", (Component)jPanel3);
            springLayout3.putConstraint("West", (Component)jLabel10, 5, "West", (Component)jPanel3);
            springLayout3.putConstraint("VerticalCenter", (Component)this.up1_tf, 0, "VerticalCenter", (Component)jLabel10);
            springLayout3.putConstraint("West", (Component)this.up1_tf, n, "West", (Component)jPanel3);
            springLayout3.putConstraint("North", (Component)jLabel11, 10, "South", (Component)this.up1_tf);
            springLayout3.putConstraint("West", (Component)jLabel11, 5, "West", (Component)jPanel3);
            springLayout3.putConstraint("VerticalCenter", (Component)this.over1_tf, 0, "VerticalCenter", (Component)jLabel11);
            springLayout3.putConstraint("West", (Component)this.over1_tf, n, "West", (Component)jPanel3);
            springLayout3.putConstraint("East", (Component)this.over1_tf, 0, "East", (Component)this.up1_tf);
            springLayout3.putConstraint("North", (Component)jLabel12, 10, "South", (Component)this.over1_tf);
            springLayout3.putConstraint("West", (Component)jLabel12, 5, "West", (Component)jPanel3);
            springLayout3.putConstraint("VerticalCenter", (Component)this.down1_tf, 0, "VerticalCenter", (Component)jLabel12);
            springLayout3.putConstraint("West", (Component)this.down1_tf, n, "West", (Component)jPanel3);
            springLayout3.putConstraint("East", (Component)this.down1_tf, 0, "East", (Component)this.up1_tf);
            springLayout3.putConstraint("North", (Component)jLabel13, 10, "South", (Component)this.down1_tf);
            springLayout3.putConstraint("West", (Component)jLabel13, 5, "West", (Component)jPanel3);
            springLayout3.putConstraint("VerticalCenter", (Component)this.action1_tf, 0, "VerticalCenter", (Component)jLabel13);
            springLayout3.putConstraint("West", (Component)this.action1_tf, n, "West", (Component)jPanel3);
            springLayout3.putConstraint("East", (Component)this.action1_tf, -5, "West", (Component)this.action1_btn);
            springLayout3.putConstraint("VerticalCenter", (Component)this.action1_btn, 0, "VerticalCenter", (Component)jLabel13);
            springLayout3.putConstraint("East", (Component)this.action1_btn, 0, "East", (Component)this.up1_tf);
            springLayout3.putConstraint("North", (Component)jLabel14, 10, "South", (Component)this.action1_btn);
            springLayout3.putConstraint("West", (Component)jLabel14, 5, "West", (Component)jPanel3);
            springLayout3.putConstraint("VerticalCenter", (Component)this.tooltiptext1_tf, 0, "VerticalCenter", (Component)jLabel14);
            springLayout3.putConstraint("West", (Component)this.tooltiptext1_tf, n, "West", (Component)jPanel3);
            springLayout3.putConstraint("East", (Component)this.tooltiptext1_tf, 0, "East", (Component)this.up1_tf);
            springLayout3.putConstraint("East", (Component)jPanel3, 5, "East", (Component)this.up1_tf);
            springLayout3.putConstraint("South", (Component)jPanel3, 10, "South", (Component)this.tooltiptext1_tf);
            jPanel3.setLayout(springLayout3);
            this.frame.add(jPanel3);
            JPanel jPanel4 = new JPanel(null);
            jPanel4.add(jLabel15);
            jPanel4.add(this.up2_tf);
            this.up2_tf.setPreferredSize(new Dimension(n2, this.up2_tf.getPreferredSize().height));
            jPanel4.add(jLabel16);
            jPanel4.add(this.over2_tf);
            jPanel4.add(jLabel17);
            jPanel4.add(this.down2_tf);
            jPanel4.add(jLabel18);
            jPanel4.add(this.action2_tf);
            jPanel4.add(this.action2_btn);
            jPanel4.add(jLabel19);
            jPanel4.add(this.tooltiptext2_tf);
            jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_CHECKBOX_STATE2")));
            SpringLayout springLayout4 = new SpringLayout();
            springLayout4.putConstraint("North", (Component)jLabel15, 5, "North", (Component)jPanel4);
            springLayout4.putConstraint("West", (Component)jLabel15, 5, "West", (Component)jPanel4);
            springLayout4.putConstraint("VerticalCenter", (Component)this.up2_tf, 0, "VerticalCenter", (Component)jLabel15);
            springLayout4.putConstraint("West", (Component)this.up2_tf, n, "West", (Component)jPanel4);
            springLayout4.putConstraint("North", (Component)jLabel16, 10, "South", (Component)this.up2_tf);
            springLayout4.putConstraint("West", (Component)jLabel16, 5, "West", (Component)jPanel4);
            springLayout4.putConstraint("VerticalCenter", (Component)this.over2_tf, 0, "VerticalCenter", (Component)jLabel16);
            springLayout4.putConstraint("West", (Component)this.over2_tf, n, "West", (Component)jPanel4);
            springLayout4.putConstraint("East", (Component)this.over2_tf, 0, "East", (Component)this.up2_tf);
            springLayout4.putConstraint("North", (Component)jLabel17, 10, "South", (Component)this.over2_tf);
            springLayout4.putConstraint("West", (Component)jLabel17, 5, "West", (Component)jPanel4);
            springLayout4.putConstraint("VerticalCenter", (Component)this.down2_tf, 0, "VerticalCenter", (Component)jLabel17);
            springLayout4.putConstraint("West", (Component)this.down2_tf, n, "West", (Component)jPanel4);
            springLayout4.putConstraint("East", (Component)this.down2_tf, 0, "East", (Component)this.up2_tf);
            springLayout4.putConstraint("North", (Component)jLabel18, 10, "South", (Component)this.down2_tf);
            springLayout4.putConstraint("West", (Component)jLabel18, 5, "West", (Component)jPanel4);
            springLayout4.putConstraint("VerticalCenter", (Component)this.action2_tf, 0, "VerticalCenter", (Component)jLabel18);
            springLayout4.putConstraint("West", (Component)this.action2_tf, n, "West", (Component)jPanel4);
            springLayout4.putConstraint("East", (Component)this.action2_tf, -5, "West", (Component)this.action2_btn);
            springLayout4.putConstraint("VerticalCenter", (Component)this.action2_btn, 0, "VerticalCenter", (Component)jLabel18);
            springLayout4.putConstraint("East", (Component)this.action2_btn, 0, "East", (Component)this.up2_tf);
            springLayout4.putConstraint("North", (Component)jLabel19, 10, "South", (Component)this.action2_btn);
            springLayout4.putConstraint("West", (Component)jLabel19, 5, "West", (Component)jPanel4);
            springLayout4.putConstraint("VerticalCenter", (Component)this.tooltiptext2_tf, 0, "VerticalCenter", (Component)jLabel19);
            springLayout4.putConstraint("West", (Component)this.tooltiptext2_tf, n, "West", (Component)jPanel4);
            springLayout4.putConstraint("East", (Component)this.tooltiptext2_tf, 0, "East", (Component)this.up2_tf);
            springLayout4.putConstraint("East", (Component)jPanel4, 5, "East", (Component)this.up2_tf);
            springLayout4.putConstraint("South", (Component)jPanel4, 10, "South", (Component)this.tooltiptext2_tf);
            jPanel4.setLayout(springLayout4);
            this.frame.add(jPanel4);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(jLabel21);
            SpringLayout springLayout5 = new SpringLayout();
            springLayout5.putConstraint("North", (Component)jPanel, 5, "North", (Component)this.frame.getContentPane());
            springLayout5.putConstraint("West", (Component)jPanel, 5, "West", (Component)this.frame.getContentPane());
            springLayout5.putConstraint("East", (Component)jPanel, 0, "East", (Component)jPanel4);
            springLayout5.putConstraint("North", (Component)jPanel2, 10, "South", (Component)jPanel);
            springLayout5.putConstraint("West", (Component)jPanel2, 5, "West", (Component)this.frame.getContentPane());
            springLayout5.putConstraint("East", (Component)jPanel2, 0, "East", (Component)jPanel4);
            springLayout5.putConstraint("North", (Component)jPanel3, 10, "South", (Component)jPanel2);
            springLayout5.putConstraint("West", (Component)jPanel3, 5, "West", (Component)this.frame.getContentPane());
            springLayout5.putConstraint("North", (Component)jPanel4, 10, "South", (Component)jPanel2);
            springLayout5.putConstraint("West", (Component)jPanel4, 5, "East", (Component)jPanel3);
            springLayout5.putConstraint("North", (Component)jLabel21, 10, "South", (Component)jPanel4);
            springLayout5.putConstraint("West", (Component)jLabel21, 5, "West", (Component)this.frame.getContentPane());
            springLayout5.putConstraint("North", (Component)this.ok_btn, 10, "South", (Component)jLabel21);
            springLayout5.putConstraint("West", (Component)this.ok_btn, 5, "West", (Component)this.frame.getContentPane());
            springLayout5.putConstraint("North", (Component)this.cancel_btn, 0, "North", (Component)this.ok_btn);
            springLayout5.putConstraint("West", (Component)this.cancel_btn, 5, "East", (Component)this.ok_btn);
            springLayout5.putConstraint("North", (Component)this.help_btn, 0, "North", (Component)this.cancel_btn);
            springLayout5.putConstraint("West", (Component)this.help_btn, 5, "East", (Component)this.cancel_btn);
            springLayout5.putConstraint("South", (Component)this.frame.getContentPane(), 10, "South", (Component)this.ok_btn);
            springLayout5.putConstraint("East", (Component)this.frame.getContentPane(), 5, "East", (Component)jPanel4);
            this.frame.setLayout(springLayout5);
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.lefttop_cb.setSelectedItem(this.lefttop);
        this.rightbottom_cb.setSelectedItem(this.rightbottom);
        this.xkeepratio_cb.setSelectedItem(this.xkeepratio);
        this.ykeepratio_cb.setSelectedItem(this.ykeepratio);
        this.visible_tf.setText(this.visible);
        this.help_tf.setText(this.help);
        this.state_tf.setText(this.state);
        this.up1_tf.setText(this.up1);
        this.over1_tf.setText(this.over1);
        this.down1_tf.setText(this.down1);
        this.action1_tf.setText(this.action1);
        this.tooltiptext1_tf.setText(this.tooltiptext1);
        this.up2_tf.setText(this.up2);
        this.over2_tf.setText(this.over2);
        this.down2_tf.setText(this.down2);
        this.action2_tf.setText(this.action2);
        this.tooltiptext2_tf.setText(this.tooltiptext2);
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_INVALID_MSG"), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_EXISTS_MSG").replaceAll("%i", this.id_tf.getText()), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            if (this.state_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_NOSTATE"), Language.get("ERROR_NOSTATE_TITLE"), 1);
                return;
            }
            this.up1_res = this.s.getImageResource(this.up1_tf.getText());
            if (this.up1_res == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_BITMAP_NEXIST").replaceAll("%i", this.up1_tf.getText()), Language.get("ERROR_BITMAP_NEXIST_TITLE"), 1);
                this.up1_res = this.s.getImageResource(this.up1);
                return;
            }
            this.over1_res = this.s.getImageResource(this.over1_tf.getText());
            if (!this.over1_tf.getText().equals("none") && this.over1_res == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_BITMAP_NEXIST").replaceAll("%i", this.over1_tf.getText()), Language.get("ERROR_BITMAP_NEXIST_TITLE"), 1);
                this.over1_res = this.s.getImageResource(this.over1);
                return;
            }
            this.down1_res = this.s.getImageResource(this.down1_tf.getText());
            if (!this.down1_tf.getText().equals("none") && this.down1_res == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_BITMAP_NEXIST").replaceAll("%i", this.down1_tf.getText()), Language.get("ERROR_BITMAP_NEXIST_TITLE"), 1);
                this.down1_res = this.s.getImageResource(this.down1);
                return;
            }
            this.up2_res = this.s.getImageResource(this.up2_tf.getText());
            if (this.up2_res == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_BITMAP_NEXIST").replaceAll("%i", this.up2_tf.getText()), Language.get("ERROR_BITMAP_NEXIST_TITLE"), 1);
                this.up2_res = this.s.getImageResource(this.up2);
                return;
            }
            this.over2_res = this.s.getImageResource(this.over2_tf.getText());
            if (!this.over2_tf.getText().equals("none") && this.s.getResource(this.over2_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_BITMAP_NEXIST").replaceAll("%i", this.over2_tf.getText()), Language.get("ERROR_BITMAP_NEXIST_TITLE"), 1);
                this.over2_res = this.s.getImageResource(this.over2);
                return;
            }
            this.down2_res = this.s.getImageResource(this.down2_tf.getText());
            if (!this.down2_tf.getText().equals("none") && this.down2_res == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_BITMAP_NEXIST").replaceAll("%i", this.down2_tf.getText()), Language.get("ERROR_BITMAP_NEXIST_TITLE"), 1);
                this.down2_res = this.s.getImageResource(this.down2);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/i-checkbox.html");
        } else if (actionEvent.getSource().equals(this.state_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/boolexpr.html");
        } else if (actionEvent.getSource().equals(this.action1_btn)) {
            if (this.action1_ae == null) {
                this.action1_ae = new ActionEditor(this);
            }
            this.action1_ae.editAction(this.action1_tf.getText());
        } else if (actionEvent.getSource().equals(this.action2_btn)) {
            if (this.action2_ae == null) {
                this.action2_ae = new ActionEditor(this);
            }
            this.action2_ae.editAction(this.action2_tf.getText());
        } else if (actionEvent.getSource().equals(this.visible_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/boolexpr.html");
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            List<Item> list;
            if (!this.created && (list = this.s.getParentListOf(this.id)) != null) {
                list.remove(this);
            }
            this.up1_res = this.s.getImageResource(this.up1);
            if (this.up1_res != null) {
                this.up1_res.addResourceChangeListener(this);
            }
            this.over1_res = this.s.getImageResource(this.over1);
            if (this.over1_res != null) {
                this.over1_res.addResourceChangeListener(this);
            }
            this.down1_res = this.s.getImageResource(this.down1);
            if (this.down1_res != null) {
                this.down1_res.addResourceChangeListener(this);
            }
            this.up2_res = this.s.getImageResource(this.up2);
            if (this.up2_res != null) {
                this.up2_res.addResourceChangeListener(this);
            }
            this.over2_res = this.s.getImageResource(this.over2);
            if (this.over2_res != null) {
                this.over2_res.addResourceChangeListener(this);
            }
            this.down2_res = this.s.getImageResource(this.down2);
            if (this.down2_res != null) {
                this.down2_res.addResourceChangeListener(this);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public void actionWasEdited(ActionEditor actionEditor) {
        if (actionEditor == this.action1_ae) {
            this.action1_tf.setText(this.action1_ae.getCode());
        } else if (actionEditor == this.action2_ae) {
            this.action2_tf.setText(this.action2_ae.getCode());
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Checkbox";
        string2 = string2 + " state=\"" + this.state + "\" up1=\"" + this.up1 + "\" up2=\"" + this.up2 + "\"";
        if (!this.down1.equals("none")) {
            string2 = string2 + " down1=\"" + this.down1 + "\"";
        }
        if (!this.down2.equals("none")) {
            string2 = string2 + " down2=\"" + this.down2 + "\"";
        }
        if (!this.over1.equals("none")) {
            string2 = string2 + " over1=\"" + this.over1 + "\"";
        }
        if (!this.over2.equals("none")) {
            string2 = string2 + " over2=\"" + this.over2 + "\"";
        }
        if (!this.action1.equals("none")) {
            string2 = string2 + " action1=\"" + this.action1 + "\"";
        }
        if (!this.action2.equals("none")) {
            string2 = string2 + " action2=\"" + this.action2 + "\"";
        }
        if (!this.tooltiptext1.equals("")) {
            string2 = string2 + " tooltiptext1=\"" + this.tooltiptext1 + "\"";
        }
        if (!this.tooltiptext2.equals("")) {
            string2 = string2 + " tooltiptext2=\"" + this.tooltiptext2 + "\"";
        }
        if (!this.id.equals("Unnamed")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        if (!this.lefttop.equals("lefttop")) {
            string2 = string2 + " lefttop=\"" + this.lefttop + "\"";
        }
        if (!this.rightbottom.equals("lefttop")) {
            string2 = string2 + " rightbottom=\"" + this.rightbottom + "\"";
        }
        if (this.xkeepratio) {
            string2 = string2 + " xkeepratio=\"" + String.valueOf(this.xkeepratio) + "\"";
        }
        if (this.ykeepratio) {
            string2 = string2 + " ykeepratio=\"" + String.valueOf(this.ykeepratio) + "\"";
        }
        if (!this.help.equals("")) {
            string2 = string2 + " help=\"" + this.help + "\"";
        }
        if (!this.visible.equals("true")) {
            string2 = string2 + " visible=\"" + this.visible + "\"";
        }
        string2 = string2 + "/>";
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, this.offsetx, this.offsety, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        if (!this.created) {
            return;
        }
        BufferedImage bufferedImage = null;
        bufferedImage = this.state_bool ? (!this.hovered || this.over2.equals("none") && !this.clicked || this.clicked && this.down2.equals("none") ? this.up2_res.image : (!this.clicked || this.down2.equals("none") ? this.over2_res.image : this.down2_res.image)) : (!this.hovered || this.over1.equals("none") && !this.clicked || this.clicked && this.down1.equals("none") ? this.up1_res.image : (!this.clicked || this.down1.equals("none") ? this.over1_res.image : this.down1_res.image));
        if (this.vis) {
            graphics2D.drawImage(bufferedImage, (this.x + n) * n3, (this.y + n2) * n3, bufferedImage.getWidth() * n3, bufferedImage.getHeight() * n3, null);
        }
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect((this.x + n) * n3, (this.y + n2) * n3, bufferedImage.getWidth() * n3 - 1, bufferedImage.getHeight() * n3 - 1);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        BufferedImage bufferedImage = this.up1_res.image;
        return n >= this.x + this.offsetx && n <= this.x + bufferedImage.getWidth() + this.offsetx && n2 >= this.y + this.offsety && n2 <= this.y + bufferedImage.getHeight() + this.offsety;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Checkbox: " + this.id);
        return defaultMutableTreeNode;
    }

    @Override
    public boolean uses(String string) {
        return this.up1.equals(string) || this.up2.equals(string) || this.over1.equals(string) || this.over2.equals(string) || this.down1.equals(string) || this.down2.equals(string);
    }

    @Override
    public void updateToGlobalVariables() {
        this.vis = this.s.gvars.parseBoolean(this.visible);
        this.state_bool = this.s.gvars.parseBoolean(this.state);
    }

    @Override
    public void onResourceChanged(ResourceChangedEvent resourceChangedEvent) {
        if (this.up1.equals(resourceChangedEvent.getOldID())) {
            this.up1 = resourceChangedEvent.getResource().id;
        }
        if (this.over1.equals(resourceChangedEvent.getOldID())) {
            this.over1 = resourceChangedEvent.getResource().id;
        }
        if (this.down1.equals(resourceChangedEvent.getOldID())) {
            this.down1 = resourceChangedEvent.getResource().id;
        }
        if (this.up2.equals(resourceChangedEvent.getOldID())) {
            this.up2 = resourceChangedEvent.getResource().id;
        }
        if (this.over2.equals(resourceChangedEvent.getOldID())) {
            this.over2 = resourceChangedEvent.getResource().id;
        }
        if (this.down2.equals(resourceChangedEvent.getOldID())) {
            this.down2 = resourceChangedEvent.getResource().id;
        }
    }
}

