/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;

public class Bezier {
    public final int MAX_BEZIER_POINT = 1023;
    public static final int kCoordsBoth = 0;
    public static final int kCoordsX = 1;
    public static final int kCoordsY = 2;
    int m_nbCtrlPt;
    List<Float> m_ptx = new LinkedList<Float>();
    List<Float> m_pty = new LinkedList<Float>();
    List<Float> m_ft = new LinkedList<Float>();
    int m_nbPoints;
    List<Integer> m_leftVect = new LinkedList<Integer>();
    List<Integer> m_topVect = new LinkedList<Integer>();
    List<Float> m_percVect = new LinkedList<Float>();

    public Bezier(int[] nArray, int[] nArray2, int n) {
        int n2;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.m_ptx.add(Float.valueOf(nArray[n2]));
            this.m_pty.add(Float.valueOf(nArray2[n2]));
        }
        this.m_nbCtrlPt = this.m_ptx.size();
        this.m_ft.add(Float.valueOf(1.0f));
        for (n2 = 1; n2 < this.m_nbCtrlPt; ++n2) {
            this.m_ft.add(Float.valueOf((float)n2 * this.m_ft.get(n2 - 1).floatValue()));
        }
        Point2D.Float float_ = this.computePoint(0.0f);
        this.m_leftVect.add((int)float_.getX());
        this.m_topVect.add((int)float_.getY());
        this.m_percVect.add(Float.valueOf(0.0f));
        for (float f = 1.0f; f <= 1023.0f; f += 1.0f) {
            float f2 = f / 1023.0f;
            Point2D.Float float_2 = this.computePoint(f2);
            if ((n != 0 || float_2.getX() == float_.getX() && float_2.getY() == float_.getY()) && (n != 1 || float_2.getX() == float_.getX()) && (n != 2 || float_2.getY() == float_.getY())) continue;
            this.m_percVect.add(Float.valueOf(f2));
            this.m_leftVect.add((int)float_2.getX());
            this.m_topVect.add((int)float_2.getY());
            float_.setLocation(float_2.getX(), float_2.getY());
        }
        this.m_nbPoints = this.m_leftVect.size();
        if (this.m_nbPoints == 1) {
            this.m_leftVect.add(this.m_leftVect.get(0));
            this.m_topVect.add(this.m_topVect.get(0));
            this.m_percVect.add(Float.valueOf(1.0f));
            this.m_nbPoints = 2;
        }
        this.m_percVect.set(this.m_nbPoints - 1, Float.valueOf(1.0f));
    }

    public final int getNbCtrlPoints() {
        return this.m_nbCtrlPt;
    }

    public final float getNearestPercent(int n, int n2) {
        int n3 = this.findNearestPoint(n, n2);
        return this.m_percVect.get(n3).floatValue();
    }

    public final float getMinDist(int n, int n2, float f, float f2) {
        int n3 = this.findNearestPoint(n, n2);
        double d = f * (float)(this.m_leftVect.get(n3) - n);
        double d2 = f2 * (float)(this.m_topVect.get(n3) - n2);
        return (float)Math.sqrt(d * d + d2 * d2);
    }

    public final Point2D.Float getPoint(float f) {
        int n;
        float f2 = Math.abs(this.m_percVect.get(0).floatValue() - f);
        for (n = 0; n < this.m_nbPoints; ++n) {
            float f3;
            float f4 = Math.abs(this.m_percVect.get(n).floatValue() - f);
            if (!(f3 <= f2)) break;
            f2 = f4;
        }
        return new Point2D.Float(this.m_leftVect.get(n - 1).intValue(), this.m_topVect.get(n - 1).intValue());
    }

    public final int getWidth() {
        int n = 0;
        for (int i = 0; i < this.m_nbPoints; ++i) {
            if (this.m_leftVect.get(i) < n) continue;
            n = this.m_leftVect.get(i) + 1;
        }
        return n;
    }

    public final int getHeight() {
        int n = 0;
        for (int i = 0; i < this.m_nbPoints; ++i) {
            if (this.m_topVect.get(i) < n) continue;
            n = this.m_topVect.get(i) + 1;
        }
        return n;
    }

    private int findNearestPoint(int n, int n2) {
        int n3 = 0;
        int n4 = (this.m_leftVect.get(0) - n) * (this.m_leftVect.get(0) - n) + (this.m_topVect.get(0) - n2) * (this.m_topVect.get(0) - n2);
        for (int i = 1; i < this.m_nbPoints; ++i) {
            int n5 = (this.m_leftVect.get(i) - n) * (this.m_leftVect.get(i) - n) + (this.m_topVect.get(i) - n2) * (this.m_topVect.get(i) - n2);
            if (n5 >= n4) continue;
            n4 = n5;
            n3 = i;
        }
        return n3;
    }

    private Point2D.Float computePoint(float f) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < this.m_nbCtrlPt; ++i) {
            float f4 = this.computeCoeff(i, this.m_nbCtrlPt - 1, f);
            f2 += this.m_ptx.get(i).floatValue() * f4;
            f3 += this.m_pty.get(i).floatValue() * f4;
        }
        return new Point2D.Float(f2, f3);
    }

    private float computeCoeff(int n, int n2, float f) {
        return this.power(f, n) * this.power(1.0f - f, n2 - n) * (this.m_ft.get(n2).floatValue() / this.m_ft.get(n).floatValue() / this.m_ft.get(n2 - n).floatValue());
    }

    private float power(float f, int n) {
        return (float)Math.pow(f, n);
    }
}

