/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content.playlist;

import java.awt.Component;
import org.bluray.media.PlaybackControl;
import org.bluray.media.PlaybackListener;
import org.bluray.media.PlaybackMarkEvent;
import org.bluray.media.PlaybackPlayItemEvent;
import org.videolan.BDJListeners;
import org.videolan.PlaylistInfo;
import org.videolan.TIMark;
import org.videolan.media.content.playlist.Handler;

public class PlaybackControlImpl
implements PlaybackControl {
    private BDJListeners listeners = new BDJListeners();
    private Handler player;

    protected PlaybackControlImpl(Handler player) {
        this.player = player;
    }

    public Component getControlComponent() {
        return null;
    }

    public void addPlaybackControlListener(PlaybackListener listener) {
        this.listeners.add(listener);
    }

    public void removePlaybackControlListener(PlaybackListener listener) {
        this.listeners.remove(listener);
    }

    public void skipToMark(int mark) throws IllegalArgumentException {
        this.player.seekMark(mark);
    }

    public boolean skipToNextMark(int type) throws IllegalArgumentException {
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException();
        }
        PlaylistInfo pi = this.player.getPlaylistInfo();
        if (pi == null) {
            return false;
        }
        TIMark[] marks = pi.getMarks();
        if (marks == null) {
            return false;
        }
        long time = this.player.getMediaNanoseconds();
        for (int i = 0; i < marks.length; ++i) {
            if (marks[i].getType() != type || marks[i].getStartNanoseconds() <= time) continue;
            this.player.seekMark(i);
            return true;
        }
        return false;
    }

    public boolean skipToPreviousMark(int type) throws IllegalArgumentException {
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException();
        }
        PlaylistInfo pi = this.player.getPlaylistInfo();
        if (pi == null) {
            return false;
        }
        TIMark[] marks = pi.getMarks();
        if (marks == null) {
            return false;
        }
        long time = this.player.getMediaNanoseconds();
        for (int i = marks.length - 1; i >= 0; --i) {
            if (marks[i].getType() != type || marks[i].getStartNanoseconds() >= time) continue;
            this.player.seekMark(i);
            return true;
        }
        return false;
    }

    public void skipToPlayItem(int item) throws IllegalArgumentException {
        this.player.seekPlayItem(item);
    }

    protected void onChapterReach(int chapter) {
        if (chapter <= 0) {
            return;
        }
        --chapter;
        PlaylistInfo pi = this.player.getPlaylistInfo();
        if (pi == null) {
            return;
        }
        TIMark[] marks = pi.getMarks();
        if (marks == null) {
            return;
        }
        int j = 0;
        for (int i = 0; i < marks.length; ++i) {
            if (marks[i].getType() != 1) continue;
            if (j == chapter) {
                this.notifyListeners(new PlaybackMarkEvent(this, i));
                return;
            }
            ++j;
        }
    }

    protected void onMarkReach(int mark) {
        if (mark < 0) {
            return;
        }
        PlaylistInfo pi = this.player.getPlaylistInfo();
        if (pi == null) {
            return;
        }
        TIMark[] marks = pi.getMarks();
        if (marks == null) {
            return;
        }
        if (mark >= marks.length) {
            return;
        }
        this.notifyListeners(new PlaybackMarkEvent(this, mark));
    }

    protected void onPlayItemReach(int param) {
        this.notifyListeners(new PlaybackPlayItemEvent(this, param));
    }

    private void notifyListeners(Object event) {
        this.listeners.putCallback(event);
    }
}

