/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.text;

import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ICUCompatIcs {
    private static final String TAG = "ICUCompatIcs";
    private static Method sGetScriptMethod;
    private static Method sAddLikelySubtagsMethod;

    ICUCompatIcs() {
    }

    public static String getScript(String locale) {
        try {
            if (sGetScriptMethod != null) {
                Object[] args = new Object[]{locale};
                return (String)sGetScriptMethod.invoke(null, args);
            }
        }
        catch (IllegalAccessException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return null;
    }

    public static String addLikelySubtags(String locale) {
        try {
            if (sAddLikelySubtagsMethod != null) {
                Object[] args = new Object[]{locale};
                return (String)sAddLikelySubtagsMethod.invoke(null, args);
            }
        }
        catch (IllegalAccessException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return locale;
    }

    static {
        try {
            Class<?> clazz = Class.forName("libcore.icu.ICU");
            if (clazz != null) {
                sGetScriptMethod = clazz.getMethod("getScript", String.class);
                sAddLikelySubtagsMethod = clazz.getMethod("addLikelySubtags", String.class);
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }
}

