/*****************************************************************************
 * UIImage+AverageColor.swift
 * VLC for iOS
 *****************************************************************************
 * Copyright © 2022 VLC authors and VideoLAN
 * Copyright © 2022 Videolabs
 *
 * Authors: Diogo Simao Marques <dogo@videolabs.io>
 *
 * Refer to the COPYING file of the official project for license.
 *****************************************************************************/

import UIKit

extension UIImage {
    var averageColor: UIColor? {
        autoreleasepool {
            guard let inputImage = CIImage(image: self) else {
                return nil
            }

            let extentVector = CIVector(x: inputImage.extent.origin.x,
                                        y: inputImage.extent.origin.y,
                                        z: inputImage.extent.size.width,
                                        w: inputImage.extent.size.height)

            guard let filter = CIFilter(name: "CIAreaAverage", parameters: [kCIInputImageKey: inputImage,
                                                                           kCIInputExtentKey: extentVector]) else {
                return nil
            }

            guard let outputImage = filter.outputImage else {
                return nil
            }

            var bitmap = [UInt8](repeating: 0, count: 4)
            let context = CIContext(options: [.workingColorSpace: kCFNull as Any])
            context.render(outputImage,
                           toBitmap: &bitmap,
                           rowBytes: 4,
                           bounds: CGRect(x: 0, y: 0, width: 1, height: 1),
                           format: .RGBA8,
                           colorSpace: nil)

            return UIColor(red: CGFloat(bitmap[0]) / 255,
                           green: CGFloat(bitmap[1]) / 255,
                           blue: CGFloat(bitmap[2]) / 255,
                           alpha: CGFloat(bitmap[3]) / 255)
        }
    }
}
