//
// kaxdemux.h

//
// kaxdemux - Matroska DirectShow Praser Filter
//
// written by Jan-David Schlenker (kromyx/myFUN)
//

// Our GUID. Generated by the wizard to be unique.
// {b29a0820-3b3a-11d7-831a-000374890932}

#ifndef __KAXDEMUX_H__
#define __KAXDEMUX_H__

#include "global.h"

using namespace LIBMATROSKA_NAMESPACE;

DEFINE_GUID(CLSID_KAXDEMUX,
0xb29a0820, 0x3b3a, 0x11d7, 0x83, 0x1a, 0x00, 0x03, 0x74, 0x89, 0x09, 0x32);

// {E73A985A-29B1-44db-BB6A-C88DA3B9E3B2}
DEFINE_GUID(MEDIASUBTYPE_Matroska, 
0xe73a985a, 0x29b1, 0x44db, 0xbb, 0x6a, 0xc8, 0x8d, 0xa3, 0xb9, 0xe3, 0xb2);

class CKaxInPin;
class CKaxOutPin;
class CKaxDemuxFilter;
class MatroskaReader;

typedef CGenericList<CKaxOutPin> COutPinList;


//
// Ckaxdemux
//

// to initialize CStreamer class
struct CStrInit {
	EbmlElement	*pElems[6];
	EbmlStream	*pStream;
	IOCallback	*pKaxIO;
	CCritSec	*pLock;
	double		TimeScale;
	int			iLevel;
	int			iUpElLev;
	COutPinList	*pOutPins;
	CKaxDemuxFilter *pFilter;
};

class CKaxDemuxFilter : public CBaseFilter, IMediaSeeking
{
private:
	
	class CStreamer : public CAMThread {
	private:
		EbmlElement	*pElems[6];
		EbmlStream	*pStream;
		IOCallback	*pKaxIO;
		CCritSec	*pLock;
		double		TimeScale;
		int			iLevel, iUpElLev;
		uint32		dwClusterTime;
		COutPinList	*pOutPins;
		CKaxDemuxFilter *pFilter;
		REFERENCE_TIME tStr, tDiff;
		BOOL		running;

	protected:
		DWORD ThreadProc();
		KaxBlock *GetNextBlock();
	public:
		BOOL IsRunning() { return running; }
	};

	uint64		m_qwKaxSegStart;

	// Pins
	CKaxInPin	*m_pInPin;
	COutPinList	m_OutPins;
	int			m_nPins;

	CCritSec	m_StreamLock;
	CStreamer	*m_pStreamer;		// worker thread - manages delivering samples


public:

    // filter object registration information
    static const AMOVIESETUP_FILTER sudFilter;

        // called to create the COM filter oject
    static CUnknown *WINAPI CreateInstance(LPUNKNOWN punk, HRESULT *phr);
        
    virtual ~CKaxDemuxFilter();

    DECLARE_IUNKNOWN;

    STDMETHODIMP NonDelegatingQueryInterface(REFIID riid, void **ppv)
    {	
		if (riid == IID_IMediaSeeking) {
			return GetInterface(static_cast<IMediaSeeking *>(this), ppv);
		} else {
			return CBaseFilter::NonDelegatingQueryInterface(riid,ppv);
		}
    }

	// custom stuff
	int InitKaxFile(IOCallback *pIOCb);

	int GetNumTracks() { return m_nPins; }

	// simplify streaming!
	HRESULT ActivateOutPins(bool bActivate);
	HRESULT FlushOutPins(bool bBeginFlush);
	HRESULT NewSegment(int nTrack, REFERENCE_TIME tStart, REFERENCE_TIME tEnd);
	HRESULT EndOfStream(int nTrack);

	BOOL DeliverBlock(int nTrack, KaxBlock *pBlock);
	void FlushBlocks();


	MatroskaReader* m_MKReader;
	HRESULT CreateOutputPin(IOCallback *pIOCb);

	// ----- IMediaSeeking -----
	HRESULT STDMETHODCALLTYPE GetCapabilities( 
		/* [out] */ DWORD *pCapabilities);
    HRESULT STDMETHODCALLTYPE CheckCapabilities( 
		/* [out][in] */ DWORD *pCapabilities);    
    HRESULT STDMETHODCALLTYPE IsFormatSupported( 
		/* [in] */ const GUID *pFormat);    
    HRESULT STDMETHODCALLTYPE QueryPreferredFormat( 
		/* [out] */ GUID *pFormat);    
    HRESULT STDMETHODCALLTYPE GetTimeFormat( 
		/* [out] */ GUID *pFormat);    
    HRESULT STDMETHODCALLTYPE IsUsingTimeFormat( 
		/* [in] */ const GUID *pFormat);    
    HRESULT STDMETHODCALLTYPE SetTimeFormat( 
		/* [in] */ const GUID *pFormat);    
    HRESULT STDMETHODCALLTYPE GetDuration( 
		/* [out] */ LONGLONG *pDuration);    
    HRESULT STDMETHODCALLTYPE GetStopPosition( 
		/* [out] */ LONGLONG *pStop);    
    HRESULT STDMETHODCALLTYPE GetCurrentPosition( 
		/* [out] */ LONGLONG *pCurrent);    
    HRESULT STDMETHODCALLTYPE ConvertTimeFormat( 
		/* [out] */ LONGLONG *pTarget,
		/* [in] */ const GUID *pTargetFormat,
		/* [in] */ LONGLONG Source,
		/* [in] */ const GUID *pSourceFormat);    
    HRESULT STDMETHODCALLTYPE SetPositions( 
		/* [out][in] */ LONGLONG *pCurrent,
		/* [in] */ DWORD dwCurrentFlags,
		/* [out][in] */ LONGLONG *pStop,
		/* [in] */ DWORD dwStopFlags);    
    HRESULT STDMETHODCALLTYPE GetPositions( 
		/* [out] */ LONGLONG *pCurrent,
		/* [out] */ LONGLONG *pStop);    
    HRESULT STDMETHODCALLTYPE GetAvailable( 
		/* [out] */ LONGLONG *pEarliest,
		/* [out] */ LONGLONG *pLatest);    
    HRESULT STDMETHODCALLTYPE SetRate( 
		/* [in] */ double dRate);    
    HRESULT STDMETHODCALLTYPE GetRate( 
		/* [out] */ double *pdRate);    
    HRESULT STDMETHODCALLTYPE GetPreroll( 
		/* [out] */ LONGLONG *pllPreroll);

private:

    // Constructor - just calls the base class constructor
    CKaxDemuxFilter(TCHAR *tszName, LPUNKNOWN punk, HRESULT *phr);

    // return the number of pins this filter has
    virtual int GetPinCount() { return m_nPins; }

    // pointer to a pin.
    virtual CBasePin* GetPin(int n);
    // use to serialize access to filter interface methods.
    CCritSec m_FilterLock;

    // CBaseFilter derived objects cannot be copied
    CKaxDemuxFilter(const CKaxDemuxFilter&);
    CKaxDemuxFilter& operator=(const CKaxDemuxFilter&);

	// private stuff
	int InitTrack(EbmlElement **elems, int &UEL, KaxTrackInfoStruct *pTrackInfos);

	CCritSec *GetFilterLock() { return &m_FilterLock; }
	CCritSec *GetStreamLock() { return &m_StreamLock; }

	STDMETHODIMP Run(REFERENCE_TIME tStart);
	STDMETHODIMP Pause();
	STDMETHODIMP Stop();

	// ----- IMediaSeeking -----
    DWORD m_dwSeekingCaps;
    CRefTime m_rtDuration;      // length of stream
    CRefTime m_rtStart;         // source will start here
    CRefTime m_rtStop;          // source will stop here
    double m_dRateSeeking;

};

#endif __KAXDEMUX_H__
