#!/usr/bin/env python

#
# Generates wxLanguage enum (to be cut&pasted to include/wx/intl.h)
# and convertion tables (ditto to src/common/intl.cpp)
#

import string

def ReadTable():
    table = []
    f = open('langtabl.txt')
    for i in f.readlines():
        ispl = i.split()
        table.append((ispl[0], ispl[1], ispl[2], ispl[3], string.join(ispl[4:])))
    f.close()
    return table


def GenEnum(table):
   f = open('_wxlang.h', 'wt')
   f.write("""

// --- --- --- generated code begins here --- --- ---

// This enum is generated by misc/languages/genlang.py
// When making changes, please put them into misc/languages/langtabl.txt
enum wxLanguage
{
    // user's default/preffered language as got from OS:
    wxLANGUAGE_DEFAULT, 
    // unknown language, if wxLocale::GetSystemLanguage fails:
    wxLANGUAGE_UNKNOWN, 
    
""");
   for i in table:
       f.write('    %s,\n' % i[0])
   f.write("""
    // for custom, user-defined languages:
    wxLANGUAGE_USER_DEFINED
};

// --- --- --- generated code ends here --- --- ---

""")
   f.close()


def GenDocs(table):
   f = open('_wxlang.tex', 'wt')
   f.write("""

%% --- --- --- generated code begins here --- --- ---

%% This enum is generated by misc/languages/genlang.py
%% When making changes, please put them into misc/languages/langtabl.txt
\\begin{itemize}\\itemsep=0pt
\\item wxLANGUAGE_DEFAULT -- user's default language as obtained from the operating system 
\\item wxLANGUAGE_UNKNOWN -- returned by \\helpref{GetSystemLanguage}{wxlocalegetsystemlanguage}
if it fails to detect the default language 
\\item wxLANGUAGE_USER_DEFINED -- user defined languages' integer identifiers should start from
this
""");
   for i in table:
       f.write('\\item %s\n' % (i[0].replace('_','\\_')))
   f.write("""\\end{itemize}

%% --- --- --- generated code ends here --- --- ---

""")
   f.close()




def GenTable(table):
   all_langs = []
   all_sublangs = []
   
   lngtable = ''
   ifdefs = '' 
       
   for i in table:
       ican = '"%s"' % i[1]
       if ican == '"-"': ican = '""'
       ilang = i[2]
       if ilang == '-': ilang = '0'
       isublang = i[3]
       if isublang == '-': isublang = '0'
       lngtable += '   LNG(%-38s %-7s, %-15s, %-34s, %s)\n' % \
                     ((i[0]+','), ican, ilang, isublang, i[4])
       if ilang not in all_langs: all_langs.append(ilang)
       if isublang not in all_sublangs: all_sublangs.append(isublang)

   for s in all_langs:
       if s != '0':
           ifdefs += '#ifndef %s\n#define %s (0)\n#endif\n' % (s, s)
   for s in all_sublangs:
       if s != '0' and s != 'SUBLANG_DEFAULT': 
           ifdefs += '#ifndef %s\n#define %s SUBLANG_DEFAULT\n#endif\n' % (s, s)

   f = open('_wxlang.cpp', 'wt')
   f.write("""
// --- --- --- generated code begins here --- --- ---

// This table is generated by misc/languages/genlang.py
// When making changes, please put them into misc/languages/langtabl.txt

#ifndef __WIN32__

#define SETWINLANG(info,lang,sublang)

#else

#define SETWINLANG(info,lang,sublang) \\
    info.WinLang = lang, info.WinSublang = sublang;

%s

#endif // __WIN32__

#define LNG(wxlang, canonical, winlang, winsublang, desc) \\
    info.Language = wxlang;                               \\
    info.CanonicalName = wxT(canonical);                  \\
    info.Description = desc;                              \\
    SETWINLANG(info, winlang, winsublang)                 \\
    AddLanguage(info);

void wxLocale::InitLanguagesDB()
{
   wxLanguageInfo info;
   wxStringTokenizer tkn;

   %s   
};
#undef LNG

// --- --- --- generated code ends here --- --- ---

""" % (ifdefs, lngtable))
   f.close()





table = ReadTable()
GenEnum(table)
GenTable(table)
GenDocs(table)
