///////////////////////////////////////////////////////////////////////////////
// Name:        gtk/renderer.cpp
// Purpose:     implementation of wxRendererNative for wxGTK
// Author:      Vadim Zeitlin
// Modified by:
// Created:     20.07.2003
// RCS-ID:      $Id: renderer.cpp,v 1.5 2003/07/22 23:35:20 VZ Exp $
// Copyright:   (c) 2003 Vadim Zeitlin <vadim@wxwindows.org>
// License:     wxWindows license
///////////////////////////////////////////////////////////////////////////////

// ============================================================================
// declarations
// ============================================================================

// ----------------------------------------------------------------------------
// headers
// ----------------------------------------------------------------------------

// for compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#ifndef WX_PRECOMP
#endif // WX_PRECOMP

#include <gtk/gtk.h>
#include "wx/gtk/win_gtk.h"

#include "wx/window.h"
#include "wx/dc.h"
#include "wx/renderer.h"

#ifdef __WXGTK20__
    #include "wx/settings.h"
#endif // GTK 2.0

// ----------------------------------------------------------------------------
// wxRendererGTK: our wxRendererNative implementation
// ----------------------------------------------------------------------------

class WXDLLEXPORT wxRendererGTK : public wxDelegateRendererNative
{
public:
    // draw the header control button (used by wxListCtrl)
    virtual void DrawHeaderButton(wxWindow *win,
                                  wxDC& dc,
                                  const wxRect& rect,
                                  int flags = 0);

#ifdef __WXGTK20__
    // draw the expanded/collapsed icon for a tree control item
    virtual void DrawTreeItemButton(wxWindow *win,
                                    wxDC& dc,
                                    const wxRect& rect,
                                    int flags = 0);
#endif // GTK 2.0

    // draw a (vertical) sash
    //
    // VZ: doesn't work -- nothing is shown on screen, why?
#if 0
    virtual void DrawSplitterSash(wxWindow *win,
                                  wxDC& dc,
                                  const wxSize& size,
                                  wxCoord position);
#endif // 0
};

// ============================================================================
// implementation
// ============================================================================

/* static */
wxRendererNative& wxRendererNative::Get()
{
    static wxRendererGTK s_rendererGTK;

    return s_rendererGTK;
}

void
wxRendererGTK::DrawHeaderButton(wxWindow *win,
                                wxDC& dc,
                                const wxRect& rect,
                                int flags)
{
    gtk_paint_box
    (
        win->m_wxwindow->style,
        GTK_PIZZA(win->m_wxwindow)->bin_window,
        flags & wxCONTROL_DISABLED ? GTK_STATE_INSENSITIVE : GTK_STATE_NORMAL,
        GTK_SHADOW_OUT,
        (GdkRectangle*) NULL,
        win->m_wxwindow,
        (char *)"button", // const_cast
        dc.XLOG2DEV(rect.x) - 1, rect.y - 1, rect.width + 2, rect.height + 2
    );
}

#ifdef __WXGTK20__

// draw a ">" or "v" button
//
// TODO: isn't there a GTK function to draw it?
void
wxRendererGTK::DrawTreeItemButton(wxWindow* WXUNUSED(win),
                                  wxDC& dc, const wxRect& rect, int flags)
{
    dc.SetBrush(wxBrush(wxSystemSettings::GetColour(wxSYS_COLOUR_HIGHLIGHT),
                        wxSOLID));
    dc.SetPen(*wxBLACK_PEN);
    wxPoint button[3];

    const wxCoord xMiddle = rect.x + rect.width/2;
    const wxCoord yMiddle = rect.y + rect.height/2;

    if ( flags & wxCONTROL_EXPANDED )
    {
        button[0].x = rect.GetLeft();
        button[0].y = yMiddle - 2;
        button[1].x = rect.GetRight();
        button[1].y = yMiddle - 2;
        button[2].x = xMiddle;
        button[2].y = yMiddle + 3;
    }
    else // collapsed
    {
        button[0].y = rect.GetBottom();
        button[0].x = xMiddle - 2;
        button[1].y = rect.GetTop();
        button[1].x = xMiddle - 2;
        button[2].y = yMiddle;
        button[2].x = xMiddle + 3;
    }

    dc.DrawPolygon(3, button);
}

#endif // GTK 2.0

#if 0

// draw a (vertical) sash
void
wxRendererGTK::DrawSplitterSash(wxWindow *win,
                                wxDC& dc,
                                const wxSize& size,
                                wxCoord position)
{
    if ( !win->m_wxwindow->window )
    {
        // VZ: this happens on startup -- why?
        return;
    }

    gtk_paint_vline
    (
        win->m_wxwindow->style,
        win->m_wxwindow->window,
        GTK_STATE_NORMAL,
        (GdkRectangle *)NULL,
        win->m_wxwindow,
        (char *)"vpaned", // const_cast
        0, size.y, position + 3
    );

    gtk_paint_box
    (
        win->m_wxwindow->style,
        win->m_wxwindow->window,
        GTK_STATE_NORMAL,
        GTK_SHADOW_OUT,
        (GdkRectangle *)NULL,
        win->m_wxwindow,
        (char *)"paned", // const_cast
        position, 5, 10, 10
    );
}

#endif // 0

