/****************************************************************************
** libebml : parse EBML files, see http://embl.sourceforge.net/
**
** <file/class description>
**
** Copyright (C) 2003-2004 Jory Stone.  All rights reserved.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding an other license may use this file in accordance with 
** the Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.matroska.org/license/qpl/ for QPL licensing information.
** See http://www.matroska.org/license/gpl/ for GPL licensing information.
**
** Contact license@matroska.org if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

/*!
	\file
	\version \$Id: MemIOCallback.h,v 1.7 2004/01/10 15:31:03 robux4 Exp $
	\author Jory Stone <jcsston @ toughguy.net>
*/
#ifndef LIBEBML_MEMIOCALLBACK_H
#define LIBEBML_MEMIOCALLBACK_H

#include "IOCallback.h"
#include <string>
// Several gcc versions have some header problem, others don't -
// but those that do will have problems with min being defined as a
// macro upon inclusion of some stream header.
#undef min
#include <sstream>

START_LIBEBML_NAMESPACE

class EBML_DLL_API MemIOCallback : public IOCallback
{
public:
	MemIOCallback(uint64 DefaultSize = 128);
	~MemIOCallback();

	/*!
		Use this to copy some data to the Buffer from this classes data
	*/
	uint32 read(void *Buffer, size_t Size);

	/*!
		Seek to the specified position. The mode can have either SEEK_SET, SEEK_CUR
		or SEEK_END. The callback should return true(1) if the seek operation succeeded
		or false (0), when the seek fails.
	*/
	void setFilePointer(int64 Offset, seek_mode Mode=seek_beginning);

	/*!
		This callback just works like its read pendant. It returns the number of bytes written.
	*/
	size_t write(const void *Buffer, size_t Size);

	/*!
		Although the position is always positive, the return value of this callback is signed to
		easily allow negative values for returning errors. When an error occurs, the implementor
		should return -1 and the file pointer otherwise.

		If an error occurs, an exception should be thrown.
	*/
	virtual uint64 getFilePointer() {return dataBufferPos;};

	/*!
		The close callback flushes the file buffers to disk and closes the file. When using the stdio
		library, this is equivalent to calling fclose. When the close is not successful, an exception
		should be thrown.
	*/
	void close() {};

	binary *GetDataBuffer() const {return dataBuffer;};
	uint64 GetDataBufferSize() {return dataBufferTotalSize;};
	void SetDataBufferSize(uint64 newDataBufferSize) {dataBufferTotalSize = newDataBufferSize;};
	/*!
		Use this to write some data from another IOCallback
	*/
	uint32 write(IOCallback & IOToRead, size_t Size);

	bool IsOk() { return mOk; };	
	const std::string &GetLastErrorStr() { return mLastErrorStr; };
protected:
	bool mOk;
	std::string mLastErrorStr;

	binary *dataBuffer;
	/*!
		Postion where we start 'writing' to the dataBuffer
	*/
	uint64 dataBufferPos;
	/*!
		Size of the data in the dataBuffer
	*/
	uint64 dataBufferTotalSize;
	/*!
		Size of the memory malloc()/realloc()
	*/
	uint64 dataBufferMemorySize;
};

END_LIBEBML_NAMESPACE

#endif // LIBEBML_MEMIOCALLBACK_H
