/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAccessibleEvent.idl
 */

#ifndef __gen_nsIAccessibleEvent_h__
#define __gen_nsIAccessibleEvent_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIAccessible; /* forward declaration */

class nsIAccessibleDocument; /* forward declaration */

#define NS_ACCESSIBLE_EVENT_TOPIC "accessible-event"

/* starting interface:    nsIAccessibleEvent */
#define NS_IACCESSIBLEEVENT_IID_STR "87f29033-c4a6-40a3-ac7a-3ba391f9992d"

#define NS_IACCESSIBLEEVENT_IID \
  {0x87f29033, 0xc4a6, 0x40a3, \
    { 0xac, 0x7a, 0x3b, 0xa3, 0x91, 0xf9, 0x99, 0x2d }}

/**
 * An interface for accessibility events listened to
 * by in-process accessibility clients, which can be used
 * to find out how to get accessibility and DOM interfaces for
 * the event and its target. To listen to in-process accessibility invents,
 * make your object an nsIObserver, and listen for accessible-event by 
 * using code something like this:
 *   nsCOMPtr<nsIObserverService> observerService = 
 *     do_GetService("@mozilla.org/observer-service;1", &rv);
 *   if (NS_SUCCEEDED(rv)) 
 *     rv = observerService->AddObserver(this, "accessible-event", PR_TRUE);
 *
 * @status UNDER_REVIEW
 */
class NS_NO_VTABLE nsIAccessibleEvent : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IACCESSIBLEEVENT_IID)

  /**
   * The type of event, based on the enumerated event values
   * defined in this interface.
   */
  /* readonly attribute unsigned long eventType; */
  NS_IMETHOD GetEventType(PRUint32 *aEventType) = 0;

  /**
   * The nsIAccessible associated with the event.
   * Accessible events must have an nsIAccessible.
   */
  /* readonly attribute nsIAccessible accessible; */
  NS_IMETHOD GetAccessible(nsIAccessible * *aAccessible) = 0;

  /**
   * The nsIAccessibleDocument that the event target nsIAccessible
   * resides in. This can be used to get the DOM window,
   * the DOM document and the window handler, among other things.
   */
  /* readonly attribute nsIAccessibleDocument accessibleDocument; */
  NS_IMETHOD GetAccessibleDocument(nsIAccessibleDocument * *aAccessibleDocument) = 0;

  enum { EVENT_CREATE = 32768U };

  enum { EVENT_DESTROY = 32769U };

  enum { EVENT_SHOW = 32770U };

  enum { EVENT_HIDE = 32771U };

  enum { EVENT_REORDER = 32772U };

  enum { EVENT_FOCUS = 32773U };

  enum { EVENT_STATE_CHANGE = 32778U };

  enum { EVENT_LOCATION_CHANGE = 32779U };

  enum { EVENT_NAME_CHANGE = 32780U };

  enum { EVENT_DESCRIPTIONCHANGE = 32781U };

  enum { EVENT_VALUE_CHANGE = 32782U };

  enum { EVENT_PARENTCHANGE = 32783U };

  enum { EVENT_HELPCHANGE = 32784U };

  enum { EVENT_DEFACTIONCHANGE = 32785U };

  enum { EVENT_ACCELERATORCHANGE = 32786U };

  enum { EVENT_SELECTION = 32774U };

  enum { EVENT_SELECTION_ADD = 32775U };

  enum { EVENT_SELECTION_REMOVE = 32776U };

  enum { EVENT_SELECTION_WITHIN = 32777U };

  enum { EVENT_ALERT = 2U };

  enum { EVENT_FOREGROUND = 3U };

  enum { EVENT_MENUSTART = 4U };

  enum { EVENT_MENUEND = 5U };

  enum { EVENT_MENUPOPUPSTART = 6U };

  enum { EVENT_MENUPOPUPEND = 7U };

  enum { EVENT_CAPTURESTART = 8U };

  enum { EVENT_CAPTUREEND = 9U };

  enum { EVENT_MOVESIZESTART = 10U };

  enum { EVENT_MOVESIZEEND = 11U };

  enum { EVENT_CONTEXTHELPSTART = 12U };

  enum { EVENT_CONTEXTHELPEND = 13U };

  enum { EVENT_DRAGDROPSTART = 14U };

  enum { EVENT_DRAGDROPEND = 15U };

  enum { EVENT_DIALOGSTART = 16U };

  enum { EVENT_DIALOGEND = 17U };

  enum { EVENT_SCROLLINGSTART = 18U };

  enum { EVENT_SCROLLINGEND = 19U };

  enum { EVENT_MINIMIZESTART = 22U };

  enum { EVENT_MINIMIZEEND = 23U };

  enum { EVENT_ATK_PROPERTY_CHANGE = 256U };

  enum { EVENT_ATK_SELECTION_CHANGE = 257U };

  enum { EVENT_ATK_TEXT_CHANGE = 258U };

  enum { EVENT_ATK_TEXT_SELECTION_CHANGE = 259U };

  enum { EVENT_ATK_TEXT_CARET_MOVE = 260U };

  enum { EVENT_ATK_VISIBLE_DATA_CHANGE = 261U };

  enum { EVENT_ATK_TABLE_MODEL_CHANGE = 272U };

  enum { EVENT_ATK_TABLE_ROW_INSERT = 273U };

  enum { EVENT_ATK_TABLE_ROW_DELETE = 274U };

  enum { EVENT_ATK_TABLE_ROW_REORDER = 275U };

  enum { EVENT_ATK_TABLE_COLUMN_INSERT = 276U };

  enum { EVENT_ATK_TABLE_COLUMN_DELETE = 277U };

  enum { EVENT_ATK_TABLE_COLUMN_REORDER = 278U };

  enum { EVENT_ATK_LINK_SELECTED = 279U };

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIACCESSIBLEEVENT \
  NS_IMETHOD GetEventType(PRUint32 *aEventType); \
  NS_IMETHOD GetAccessible(nsIAccessible * *aAccessible); \
  NS_IMETHOD GetAccessibleDocument(nsIAccessibleDocument * *aAccessibleDocument); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIACCESSIBLEEVENT(_to) \
  NS_IMETHOD GetEventType(PRUint32 *aEventType) { return _to GetEventType(aEventType); } \
  NS_IMETHOD GetAccessible(nsIAccessible * *aAccessible) { return _to GetAccessible(aAccessible); } \
  NS_IMETHOD GetAccessibleDocument(nsIAccessibleDocument * *aAccessibleDocument) { return _to GetAccessibleDocument(aAccessibleDocument); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIACCESSIBLEEVENT(_to) \
  NS_IMETHOD GetEventType(PRUint32 *aEventType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEventType(aEventType); } \
  NS_IMETHOD GetAccessible(nsIAccessible * *aAccessible) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAccessible(aAccessible); } \
  NS_IMETHOD GetAccessibleDocument(nsIAccessibleDocument * *aAccessibleDocument) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAccessibleDocument(aAccessibleDocument); } \

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAccessibleEvent : public nsIAccessibleEvent
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIACCESSIBLEEVENT

  nsAccessibleEvent();
  virtual ~nsAccessibleEvent();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAccessibleEvent, nsIAccessibleEvent)

nsAccessibleEvent::nsAccessibleEvent()
{
  /* member initializers and constructor code */
}

nsAccessibleEvent::~nsAccessibleEvent()
{
  /* destructor code */
}

/* readonly attribute unsigned long eventType; */
NS_IMETHODIMP nsAccessibleEvent::GetEventType(PRUint32 *aEventType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIAccessible accessible; */
NS_IMETHODIMP nsAccessibleEvent::GetAccessible(nsIAccessible * *aAccessible)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIAccessibleDocument accessibleDocument; */
NS_IMETHODIMP nsAccessibleEvent::GetAccessibleDocument(nsIAccessibleDocument * *aAccessibleDocument)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIAccessibleEvent_h__ */
