#define IMAGE_SIZE (1<<(int)(log(([self bounds].size.width<[self bounds].size.height)?[self bounds].size.width:[self bounds].size.height)/log(2.0f)))

#include <sys/time.h>
#include <unistd.h>
#include <math.h>

#include "goom_core.h"

#include <QuickTime/ImageCompression.h> // for image loading and decompression
#include <QuickTime/QuickTimeComponents.h> // for file type support

#include <OpenGL/CGLCurrent.h>
#include <OpenGL/CGLContext.h>

#import "MainOpenGLView.h"

@implementation MainOpenGLView

- (void) dealloc
{
    [super dealloc];
}

- (id)initWithFrame:(NSRect)frameRect
{
    // Init pixel format attribs
    NSOpenGLPixelFormatAttribute attrs[] =
    {
        NSOpenGLPFAAccelerated,
        NSOpenGLPFANoRecovery,
        NSOpenGLPFADoubleBuffer,
        0
    };
    
    // Get pixel format from OpenGL
    NSOpenGLPixelFormat* pixFmt = [[NSOpenGLPixelFormat alloc] initWithAttributes:attrs];
    if (!pixFmt)
    {
        NSLog(@"No pixel format -- exiting");
        exit(1);
    }
    
    self = [super initWithFrame:frameRect pixelFormat:pixFmt];
    
    return self;
}
-(void)awakeFromNib
{
    [[self openGLContext] makeCurrentContext];
    
    // Init object members
    texture_hint   = GL_STORAGE_CACHED_APPLE ;
    client_storage = GL_TRUE;
    rect_texture   = GL_FALSE;
    frame_rate     = 30;
    
    //timer = [[NSTimer scheduledTimerWithTimeInterval: (1.0f / frame_rate) target: self selector:@selector(drawRect:) userInfo:self repeats:true] retain];
    timer = [[NSTimer scheduledTimerWithTimeInterval:0.0f target: self selector:@selector(drawRect:) userInfo:self repeats:true] retain];
    
    // Setup some basic OpenGL stuff
    glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
    glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
    glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
    glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    
    // Init fps timer
    gettimeofday(&cycle_time, NULL);
    
    // Call for a redisplay
    [self setNeedsDisplay:true];
    
}

- (void)displayMPixels
{
    static long loop_count = 0;
    struct timeval t2;
    unsigned long t;
    
    loop_count++;
    
    gettimeofday(&t2, NULL);
    t = 1000000 * (t2.tv_sec - cycle_time.tv_sec) + (t2.tv_usec - cycle_time.tv_usec);
    
    // Display the average data rate
    if(t > 1000000 * STAT_UPDATE)
    {
        gettimeofday(&t2, NULL);
        t = 1000000 * (t2.tv_sec - cycle_time.tv_sec) + (t2.tv_usec - cycle_time.tv_usec);
        gettimeofday(&cycle_time, NULL);
        avg_fps = (1000000.0f * (float) loop_count) / (float) t;
        
        //[setMPixels setFloatValue:(avg_fps * [self bounds].size.width * [self bounds].size.height * (IMAGE_DEPTH >> 3)) / 1000000];
        
        loop_count = 0;
        
        gettimeofday(&cycle_time, NULL);
    }
}

- (void)drawRect:(NSRect)aRect
{
    struct	timeval t1, t2;
    GLfloat	t=0;
    //static float evolution = 0.0f;
    glClear(0);
    // Make this context current
    [[self openGLContext] makeCurrentContext];
    
    // Bind, update and draw new image
    if(rect_texture)
    {
        gettimeofday(&t1, NULL);
        
        glBindTexture(GL_TEXTURE_RECTANGLE_EXT, 1);
        
        // glTexSubImage2D is faster when not using a texture range
        
        glTexSubImage2D(GL_TEXTURE_RECTANGLE_EXT, 0, 0, 0, [self bounds].size.width, [self bounds].size.height, GL_BGRA, GL_UNSIGNED_INT_8_8_8_8_REV, [myGoom getGoomDataWithFPS:avg_fps]);
        //glTexImage2D(GL_TEXTURE_RECTANGLE_EXT, 0, GL_RGBA, IMAGE_SIZE, IMAGE_SIZE, 0, GL_BGRA, GL_UNSIGNED_INT_8_8_8_8_REV, image[draw_image]);
        glBegin(GL_QUADS);
        glTexCoord2f(0.0f, 0.0f);
        glVertex2f(-1.0f, 1.0f);
        
        glTexCoord2f(0.0f, [self bounds].size.height);
        glVertex2f(-1.0f, -1.0f);
        
        glTexCoord2f([self bounds].size.width, [self bounds].size.height);
        glVertex2f(1.0f, -1.0f);
        
        glTexCoord2f([self bounds].size.width, 0.0f);
        glVertex2f(1.0f, 1.0f);
        glEnd();
        
        glFlush();
        
        
        gettimeofday(&t2, NULL);
        t = 1000000.0f *(t2.tv_sec - t1.tv_sec) +(t2.tv_usec - t1.tv_usec);
        
    }
    else
    {
        gettimeofday(&t1, NULL);
        
        glBindTexture(GL_TEXTURE_2D, 1);
        
        // glTexSubImage2D is faster when not using a texture range
        glTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, IMAGE_SIZE, IMAGE_SIZE, GL_BGRA, GL_UNSIGNED_INT_8_8_8_8_REV, [myGoom getGoomDataWithFPS:avg_fps]);
        //glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, IMAGE_SIZE, IMAGE_SIZE, 0, GL_BGRA, GL_UNSIGNED_INT_8_8_8_8_REV, image[draw_image]);
        /*
         evolution += 0.01f;
         evolution = ( evolution > ( 2 * M_PI)) ? 0 : evolution;
         glBegin(GL_QUAD_STRIP);
         glTexCoord2f(0.0f, 0.0f);
         glVertex3f(-1.0f, 1.0f, 0.0f);
         glTexCoord2f(0.0f, 1.0f);
         glVertex3f(-1.0f, -1.0f, 0.0f);
         glTexCoord2f(0.5f, 0.0f);
         glVertex3f(1.0f, 1.0f, 0.0f);
         glTexCoord2f(0.5f, 1.0f);
         glVertex3f(1.0f, -1.0f, 0.0f);
         
         
         glTexCoord2f(1.0f, 0.0f);
         glVertex3f(1.0f, 1.0f, 2.0f);
         glTexCoord2f(1.0f, 1.0f);
         glVertex3f(1.0f, -1.0f, 2.0f);
         
         glEnd();
         */
        
        glBegin(GL_QUADS);
        glTexCoord2f(0.0f, 0.0f);
        glVertex2f(-1.0f, 1.0f);
        glTexCoord2f(0.0f, 1.0f);
        glVertex2f(-1.0f, -1.0f);
        
        glTexCoord2f(1.0f, 1.0f);
        glVertex2f(1.0f, -1.0f);
        
        glTexCoord2f(1.0f, 0.0f);
        glVertex2f(1.0f, 1.0f);
        glEnd();
        
        glFlush();
								
        gettimeofday(&t2, NULL);
        t = 1000000.0f *(t2.tv_sec - t1.tv_sec) +(t2.tv_usec - t1.tv_usec);
    }
    [sizeField setStringValue:[NSString stringWithFormat:@"Picture size: %d * %d @ %.1f FPS",(int)[self bounds].size.width,(int)[self bounds].size.height, avg_fps]];
    
    //glRotatef(evolution, 1.0f, 1.0f, 1.0f);
    
    // Swap buffer to screen
    [[self openGLContext] flushBuffer];
    
    // Display the average data rate
    [self displayMPixels];
}

- (void)update  // moved or resized
{
    NSRect rect;
    
    [super update];
    
    [[self openGLContext] makeCurrentContext];
    [[self openGLContext] update];
    
    rect = [self bounds];
    
    glViewport(0, 0, (int) rect.size.width, (int) rect.size.height);
    
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity(); 
    
    [self setNeedsDisplay:true];
}

- (void)reshape	// scrolled, moved or resized
{
    NSRect rect;
    
    [super reshape];
    
    [[self openGLContext] makeCurrentContext];
    [[self openGLContext] update];
    
    rect = [self bounds];
    
    glViewport(0, 0, (int) rect.size.width, (int) rect.size.height);
    
    [self loadTextures:GL_FALSE];
    
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    
    [self setNeedsDisplay:true];
}

- (IBAction) clientStorage: (id) sender
{
    client_storage = [sender state];
    
    [self loadTextures:GL_FALSE];
}

- (IBAction) textureRange: (id) sender
{
}

- (IBAction) infinite: (id) sender
{
}

- (IBAction) rectTextures: (id) sender
{
    rect_texture = [sender state];
    
    [self loadTextures:GL_FALSE];
}

- (IBAction) textureHint: (id) sender
{
    if([[sender titleOfSelectedItem] isEqualToString:@"Cached"])   texture_hint = GL_STORAGE_CACHED_APPLE;
    if([[sender titleOfSelectedItem] isEqualToString:@"Private"])  texture_hint = GL_STORAGE_PRIVATE_APPLE;
    if([[sender titleOfSelectedItem] isEqualToString:@"Shared"])   texture_hint = GL_STORAGE_SHARED_APPLE;
    
    [self loadTextures:GL_FALSE];
}

- (IBAction) numBuffers: (id) sender
{
}

- (IBAction) frameRate: (id) sender
{
    GLfloat t;
    frame_rate = [sender intValue];
    
    t = 1.0f / (GLfloat) frame_rate;
    
    [timer invalidate];
    [timer release];
    
    timer = [[NSTimer scheduledTimerWithTimeInterval:t target: self selector:@selector(drawRect:) userInfo:self repeats:true] retain];
}

- (void)loadTextures: (GLboolean)first
{
    PluginInfo * goomInfos = [myGoom infos];

    NSRect rect = [self bounds];
    
    [[self openGLContext] makeCurrentContext];
    [[self openGLContext] update];
				glEnable(GL_LIGHTING);
                
                if(rect_texture)
                {
                    if(!first)
                    {
                        GLint dt = 1;
                        glDeleteTextures(1, &dt);
                    }
                    
                    goom_set_resolution (goomInfos, rect.size.width, rect.size.height);
                    
                    glDisable(GL_TEXTURE_2D);
                    glEnable(GL_TEXTURE_RECTANGLE_EXT);
                    glBindTexture(GL_TEXTURE_RECTANGLE_EXT, 1);
                    
                    glTextureRangeAPPLE(GL_TEXTURE_RECTANGLE_EXT, 0, NULL);
                    
                    glTexParameteri(GL_TEXTURE_RECTANGLE_EXT, GL_TEXTURE_STORAGE_HINT_APPLE , texture_hint);
                    glPixelStorei(GL_UNPACK_CLIENT_STORAGE_APPLE, client_storage);
                    glTexParameteri(GL_TEXTURE_RECTANGLE_EXT, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                    glTexParameteri(GL_TEXTURE_RECTANGLE_EXT, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
                    glTexParameteri(GL_TEXTURE_RECTANGLE_EXT, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
                    glTexParameteri(GL_TEXTURE_RECTANGLE_EXT, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
                    glPixelStorei(GL_UNPACK_ROW_LENGTH, 0);
                    
                    glTexImage2D(GL_TEXTURE_RECTANGLE_EXT, 0, GL_RGBA, [self bounds].size.width,
                                 [self bounds].size.height, 0, GL_BGRA, GL_UNSIGNED_INT_8_8_8_8_REV, [myGoom getGoomDataWithFPS:avg_fps]);
                }
                else
                {
                    glTextureRangeAPPLE(GL_TEXTURE_RECTANGLE_EXT, 0, NULL);
                    glTextureRangeAPPLE(GL_TEXTURE_2D, 0, NULL);
                    
                    if(!first)
                    {
                        GLint dt = 1;
                        glDeleteTextures(1, &dt);
                    }
                    
                    goom_set_resolution (goomInfos,IMAGE_SIZE, IMAGE_SIZE);
                    
                    glDisable(GL_TEXTURE_RECTANGLE_EXT);
                    glEnable(GL_TEXTURE_2D);
                    glBindTexture(GL_TEXTURE_2D, 1);
                    
                    glTextureRangeAPPLE(GL_TEXTURE_2D, 0, NULL);
                    
                    glTexParameteri(GL_TEXTURE_RECTANGLE_EXT, GL_TEXTURE_STORAGE_HINT_APPLE , texture_hint);
                    glPixelStorei(GL_UNPACK_CLIENT_STORAGE_APPLE, client_storage);
                    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
                    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
                    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
                    glPixelStorei(GL_UNPACK_ROW_LENGTH, 0);
                    
                    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, IMAGE_SIZE,
                                 IMAGE_SIZE, 0, GL_BGRA, GL_UNSIGNED_INT_8_8_8_8_REV, [myGoom getGoomDataWithFPS:avg_fps]);
                }
}

- (void)mouseDragged:(NSEvent *)theEvent
{
}

- (void)mouseDown:(NSEvent *)theEvent
{
}

@end
