#include <glib.h>
#include "goom_config.h"

#include <xmms/plugin.h>
#include <xmms/xmmsctrl.h>

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <signal.h>

static void plug_init (void);
static void plug_cleanup (void);
static void plug_render_pcm (gint16 data[2][512]);

int fd_in, fd_out;
pid_t goom_pid;

VisPlugin plug_vp = {
  NULL,
  NULL,
  0,
  "What A GOOM!! " VERSION,
  2,
  0,
  plug_init,/* init */
  plug_cleanup,/* cleanup */
  NULL,/* about */
  NULL,/* configure */
  NULL,/* disable_plugin */
  NULL,/* playback_start */
  NULL,/* playback_stop */
  plug_render_pcm,
  /* render_pcm */
  /* jeko_render_freq */ NULL
  /* render_freq */
};

VisPlugin *
get_vplugin_info (void)
{
  return &plug_vp;
}

static void
plug_init (void)
{
  int fd[2];
  pid_t pid;

  /* create a pipe */
  if (pipe(fd) < 0) {
    fprintf (stderr, "System Error\n");
    /* TODO: en gtk? */
    return;
  }
  fd_in = fd[0];
  fd_out = fd[1];

  /* load an executable */
  pid = fork();

  /* todo look at the result */
  if (pid == 0) {
    dup2(fd_in, 0);

    execlp ("goom2", "goom2", NULL, 0);
    fprintf (stderr, "Unable to load goom...\n"); /* TODO: Message en gtk
						     check the PATH */
    exit (1);
  }
  if (pid == -1) {
    /* erreur system : TODO -> dialog en gtk */
  }
  goom_pid = pid;
}

static void
plug_cleanup (void)
{
  kill (goom_pid, SIGQUIT);
}

static void
plug_render_pcm (gint16 data[2][512])
{
  {
    fd_set rfds;
    struct timeval tv;
    int retval;
    
    tv.tv_sec = 0;
    tv.tv_usec = 100;
    
    FD_ZERO(&rfds);
    FD_SET(fd_out, &rfds);
    retval = select(fd_out+1, NULL, &rfds, NULL, &tv);
    if (retval) {
      write (fd_out, &data[0], 512*2*2);
    }
    else {
	usleep(100);
    }
  }
}
