/*
 *		This Code Was Created By Jeff Molofee 2000
 *		A HUGE Thanks To Fredric Echols For Cleaning Up
 *		And Optimizing The Base Code, Making It More Flexible!
 *		If You've Found This Code Useful, Please Let Me Know.
 *		Visit My Site At nehe.gamedev.net
 */

#include <windows.h>		// Header File For Windows
#include "tinyptc.h"
#include <stdio.h>			// Header File For Standard Input/Output
#include <gl\gl.h>			// Header File For The OpenGL32 Library
#include <gl\glu.h>			// Header File For The GLu32 Library

#ifdef VIS_GOOM
#include "vis.h"
extern struct winampVisModule *init_mod;
#endif

#ifdef WAVEINBUILD
extern void goom_audio_finish(int iFinish);
#endif


static HDC			hDC=NULL;		// Private GDI Device Context
static HGLRC		hRC=NULL;		// Permanent Rendering Context
static HWND		hWnd=NULL;		// Holds Our Window Handle
static HINSTANCE	hInstance;		// Holds The Instance Of The Application

static BOOL	keys[256];			// Array Used For The Keyboard Routine
static BOOL	active=TRUE;		// Window Active Flag Set To TRUE By Default
static BOOL	fullscreen=FALSE;	// Fullscreen Flag Set To Fullscreen Mode By Default
static BOOL hwndSet=FALSE;


static LRESULT	CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);	// Declaration For WndProc
static int surface_width;
static int surface_height;

#ifdef __PTC_WINDOWED__
static SIZE oldsz;
static POINT oldpt;
#endif

#ifdef __PTC_SYSTEM_MENU__
// menu option identifier
#define SC_ZOOM_MSK 0x400
#define SC_ZOOM_1x1 0x401
#define SC_ZOOM_2x2 0x402
#define SC_ZOOM_4x4 0x404
static int original_window_width;
static int original_window_height;
static HMENU system_menu;
#endif
static HWND parwnd = NULL;
static HINSTANCE parinst = NULL;
static int got_destroyed;
#ifdef WMP_GOOM
int do_destroy=1;
#endif

GLvoid ReSizeGLScene(GLsizei width, GLsizei height)		// Resize And Initialize The GL Window
{
	int yv = 0;
	int xv = 0;
	if (height==0)										// Prevent A Divide By Zero By
	{
		height=1;										// Making Height Equal One
	}
	if (parwnd != NULL) {
		SetWindowPos(hWnd,NULL,0,0,width,height,SWP_NOMOVE | SWP_NOZORDER);
	}
#ifdef SCREENSAVBUILD
//	yv = (GetSystemMetrics(SM_CYSCREEN) - height)/2;
//	if (yv < 0) yv = 0;
//	xv = (GetSystemMetrics(SM_CXSCREEN) - width)/2;
//	if (xv < 0) xv=0;
#endif

	glViewport(xv,yv,width,height);						// Reset The Current Viewport

	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glLoadIdentity();									// Reset The Projection Matrix

	// Calculate The Aspect Ratio Of The Window
	gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,0.1f,100.0f);

	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	glLoadIdentity();									// Reset The Modelview Matrix 
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer
}
static GLuint	texture[1];
static GLfloat	xrot;				// X Rotation ( NEW )
static GLfloat	yrot;				// Y Rotation ( NEW )
static GLfloat	zrot;				// Z Rotation ( NEW )
GLfloat zshift = -5.0f;


static int inittexture(GLsizei width, GLsizei height)									// Load Bitmaps And Convert To Textures
{

    unsigned int *tmpbuf;

    int sts = 0;

	// Load The Bitmap, Check For Errors, If Bitmap's Not Found Quit
	if ((tmpbuf = (unsigned int *)malloc(width*height*sizeof(unsigned int))) )
	{
        int i;
        for (i = 0; i < (width*height); i++) {
            tmpbuf[i]=(0x00<< 24) | (0xaa << 16) | (0x00 << 8) | 0x00;
        }
		sts=1;									// Set The Status To TRUE

		glGenTextures(1, &texture[0]);					// Create The Texture

		// Typical Texture Generation Using Data From The Bitmap
		glBindTexture(GL_TEXTURE_2D, texture[0]);
		glTexImage2D(GL_TEXTURE_2D, 0, 4, width, height, 0, GL_BGRA_EXT, GL_UNSIGNED_BYTE, tmpbuf);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	}

	if (tmpbuf)									// If Texture Exists
	{
		free(tmpbuf);								// Free The Image Structure
	}

	return sts;										// Return The Status
}


static int InitGL(GLsizei width, GLsizei height)										// All Setup For OpenGL Goes Here
{
	if (inittexture(width, height) == 0)								// Jump To Texture Loading Routine ( NEW )
	{
        fprintf(stderr,"Failed to load textures");
		return 0;									// If Texture Didn't Load Return FALSE
	}

	glEnable(GL_TEXTURE_2D);							// Enable Texture Mapping ( NEW )
//	glShadeModel(GL_SMOOTH);							// Enable Smooth Shading
	glClearColor(0.0f, 0.0f, 0.0f, 0.5f);				// Black Background
	glClearDepth(1.0f);									// Depth Buffer Setup
	glEnable(GL_DEPTH_TEST);							// Enables Depth Testing
	glDepthFunc(GL_LEQUAL);								// The Type Of Depth Testing To Do
//	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	// Really Nice Perspective Calculations
//    glEnable(GL_BLEND);
//    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

    xrot=0.0f;
    yrot=0.0f;
    zrot=0.0f;


	return TRUE;										// Initialization Went OK
}

static GLvoid abmap(GLfloat x0in, GLfloat y0in, GLfloat z0in, 
                GLfloat x1in, GLfloat y1in, GLfloat z1in)
{

#if 0
    GLfloat x[3],x1[3],x0[3],xp[3];
    GLfloat a;
    GLfloat stp;
    GLfloat d1,d2;
    int i;

    x0[0]=x0in;
    x0[1]=y0in;
    x0[2]=z0in;
    x1[0]=x1in;
    x1[1]=y1in;
    x1[2]=z1in;

    stp=0.05f;
    d2=0.02f*sin(yrot/10.0f);
    for (a=0.0f; a < (1.001f-stp); a+=stp) {
        d1=d2;
        d2=0.02f*sin(10.0f*(a+stp)+yrot/10.0f);
        for (i = 0; i < 3; i++) {
            x[i]=x0[i]+a*(x1[i]-x0[i]);
            xp[i]=x0[i]+(a+stp)*(x1[i]-x0[i]);
//            x[i]=x0[i]+a*(x1[i]-x0[i]);
//            xp[i]=x0[i]+(a+stp)*(x1[i]-x0[i]);
        }
//        glColor4f(1.0f,1.0f,1.0f,1.0f);
        if (x0[2] == x1[2]) {
            glTexCoord2f(a,0.0f); glVertex3f(x0[0]+d1,x[1],x0[2]);
            glTexCoord2f(a,1.0f); glVertex3f(x1[0]+d2,x[1],x0[2]);
            glTexCoord2f(a+stp,1.0f); glVertex3f(x1[0]+d2,xp[1],x0[2]);
            glTexCoord2f(a+stp,0.0f); glVertex3f(x0[0]+d1,xp[1],x0[2]);
        } else if (x0[0] == x1[0]) {
            glTexCoord2f(a,0.0f); glVertex3f(x0[0],x0[1]+d1,x[2]);
            glTexCoord2f(a,1.0f); glVertex3f(x0[0],x1[1]+d2,x[2]);
            glTexCoord2f(a+stp,1.0f); glVertex3f(x0[0],x1[1]+d2,xp[2]);
            glTexCoord2f(a+stp,0.0f); glVertex3f(x0[0],x0[1]+d1,xp[2]);
        } else {
            glTexCoord2f(a,0.0f); glVertex3f(x[0],x0[1],x0[2]+d1);
            glTexCoord2f(a,1.0f); glVertex3f(x[0],x0[1],x1[2]+d2);
            glTexCoord2f(a+stp,1.0f); glVertex3f(xp[0],x0[1],x1[2]+d2);
            glTexCoord2f(a+stp,0.0f); glVertex3f(xp[0],x0[1],x0[2]+d1);
        }
    }
#else
    if (z0in == z1in) {
        glTexCoord2f(0.0f,0.0f); glVertex3f(0.98f*x0in,0.98f*y0in,z0in);
        glTexCoord2f(0.0f,1.0f); glVertex3f(0.98f*x1in,0.98f*y0in,z0in);
        glTexCoord2f(1.0f,1.0f); glVertex3f(0.98f*x1in,0.98f*y1in,z0in);
        glTexCoord2f(1.0f,0.0f); glVertex3f(0.98f*x0in,0.98f*y1in,z0in);
    } else if (x0in == x1in) {
        glTexCoord2f(0.0f,0.0f); glVertex3f(x0in,0.98f*y0in,0.98f*z0in);
        glTexCoord2f(0.0f,1.0f); glVertex3f(x0in,0.98f*y1in,0.98f*z0in);
        glTexCoord2f(1.0f,1.0f); glVertex3f(x0in,0.98f*y1in,0.98f*z1in);
        glTexCoord2f(1.0f,0.0f); glVertex3f(x0in,0.98f*y0in,0.98f*z1in);
    } else {
        glTexCoord2f(0.0f,0.0f); glVertex3f(0.98f*x0in,y0in,0.98f*z0in);
        glTexCoord2f(0.0f,1.0f); glVertex3f(0.98f*x0in,y1in,0.98f*z1in);
        glTexCoord2f(1.0f,1.0f); glVertex3f(0.98f*x1in,y1in,0.98f*z1in);
        glTexCoord2f(1.0f,0.0f); glVertex3f(0.98f*x1in,y0in,0.98f*z0in);
    }
#endif
}
int msg_rotate_ogl = 0;

static GLvoid DrawGLScene(void *buffer) 
{ 
	static int itrans = 0;
	static GLfloat xrdelt,yrdelt,zrdelt,zsdelt,zhold,zhold2;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer
//	glClear(GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer
	glLoadIdentity();									// Reset The View
	if (msg_rotate_ogl) {
		if (itrans == 0) {
			xrdelt = (0.0f-xrot)/60.0f;
			yrdelt = (0.0f-yrot)/60.0f;
			zrdelt = (-90.0f-zrot)/60.0f;
			zsdelt = (-4.0f-zshift)/60.0f;
			zhold=zshift;
			zhold2=zshift;
		}
		if (itrans < 60) {
			zshift = zhold;
			zshift += zsdelt;
			zhold = zshift;
//			xrot += xrdelt;
//			yrot += yrdelt;
			xrot = 0.0f;
			yrot = 0.0f;
			zrot += zrdelt;
			itrans++;
		}
	} else {
		if (itrans > 0) zshift = zhold2;
		itrans = 0;
	}
	glTranslatef(0.0f,0.0f,zshift);

	glRotatef(xrot,1.0f,0.0f,0.0f);
	glRotatef(yrot,0.0f,1.0f,0.0f);
	glRotatef(zrot,0.0f,0.0f,1.0f);

	glBindTexture(GL_TEXTURE_2D, texture[0]);
	glTexImage2D(GL_TEXTURE_2D, 0, 4, surface_width, surface_height, 0, GL_BGRA_EXT, GL_UNSIGNED_BYTE, buffer);

#if 1
	glBegin(GL_QUADS);
		// Front Face
//		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);
//		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);
//		glTexCoord2f(0.4f, 0.0f); glVertex3f(-0.1f, -1.0f,  1.0f);
//		glTexCoord2f(0.6f, 0.0f); glVertex3f( 0.1f, -1.0f,  1.0f);
//		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);
//		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);
        abmap(-1.0f,-1.0f,1.0f, 1.0f,1.0f,1.0f);
		// Back Face
//		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);
//		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);
//		glTexCoord2f(1.0f, 0.4f); glVertex3f(-1.0f, -0.1f, -1.0f);
//		glTexCoord2f(1.0f, 0.6f); glVertex3f(-1.0f,  0.1f, -1.0f);
//		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);
//		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);
        abmap(-1.0f,-1.0f,-1.0f, 1.0f,1.0f,-1.0f);
		// Top Face
//		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);
//		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f,  1.0f,  1.0f);
//		glTexCoord2f(0.0f, 0.6f); glVertex3f(-1.0f,  1.0f, -0.1f);
//		glTexCoord2f(0.0f, 0.4f); glVertex3f(-1.0f,  1.0f,  0.1f);
//		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f,  1.0f,  1.0f);
//		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);
        abmap(-1.0f,1.0f,-1.0f, 1.0f,1.0f,1.0f);
		// Bottom Face
//		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f, -1.0f, -1.0f);
//		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f, -1.0f, -1.0f);
//		glTexCoord2f(0.6f, 1.0f); glVertex3f(-0.1f, -1.0f, -1.0f);
//		glTexCoord2f(0.4f, 1.0f); glVertex3f( 0.1f, -1.0f, -1.0f);
//		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);
//		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);
        abmap(-1.0f,-1.0f,-1.0f, 1.0f,-1.0f,1.0f);
		// Right face
//		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);
//		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);
//		glTexCoord2f(1.0f, 0.4f); glVertex3f( 1.0f, -0.1f, -1.0f);
//		glTexCoord2f(1.0f, 0.6f); glVertex3f( 1.0f,  0.1f, -1.0f);
//		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);
//		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);
        abmap(1.0f,-1.0f,-1.0f, 1.0f,1.0f,1.0f);
		// Left Face
//		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);
//		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);
//		glTexCoord2f(0.4f, 0.0f); glVertex3f(-1.0f, -1.0f, -0.1f);
//		glTexCoord2f(0.6f, 0.0f); glVertex3f(-1.0f, -1.0f,  0.1f);
//		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);
//		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);
        abmap(-1.0f,-1.0f,-1.0f, -1.0f,1.0f,1.0f);
#else
    glBegin(GL_TRIANGLES);
    {
        float yedge=-1.0f;
        float ytop=-0.1f;

        glTexCoord2f(0.0f,1.0f); glVertex3f(-1.0f,yedge,1.0f);
        glTexCoord2f(0.5f,0.0f); glVertex3f(0.0f,ytop,0.0f);
        glTexCoord2f(1.0f,0.0f); glVertex3f(1.0f,yedge,1.0f);

        glTexCoord2f(0.0f,1.0f); glVertex3f(-1.0f,yedge,-1.0f);
        glTexCoord2f(0.5f,0.0f); glVertex3f(0.0f,ytop,0.0f);
        glTexCoord2f(1.0f,0.0f); glVertex3f(-1.0f,yedge,1.0f);

        glTexCoord2f(0.0f,1.0f); glVertex3f(-1.0f,yedge,-1.0f);
        glTexCoord2f(0.5f,0.0f); glVertex3f(0.0f,ytop,0.0f);
        glTexCoord2f(1.0f,0.0f); glVertex3f(1.0f,yedge,-1.0f);

        glTexCoord2f(0.0f,1.0f); glVertex3f(1.0f,yedge,-1.0f);
        glTexCoord2f(0.5f,0.0f); glVertex3f(0.0f,ytop,0.0f);
        glTexCoord2f(1.0f,0.0f); glVertex3f(1.0f,yedge,1.0f);

        yedge=1.0f;
        ytop=0.1f;

        glTexCoord2f(0.0f,1.0f); glVertex3f(-1.0f,yedge,1.0f);
        glTexCoord2f(0.5f,0.0f); glVertex3f(0.0f,ytop,0.0f);
        glTexCoord2f(1.0f,0.0f); glVertex3f(1.0f,yedge,1.0f);

        glTexCoord2f(0.0f,1.0f); glVertex3f(-1.0f,yedge,-1.0f);
        glTexCoord2f(0.5f,0.0f); glVertex3f(0.0f,ytop,0.0f);
        glTexCoord2f(1.0f,0.0f); glVertex3f(-1.0f,yedge,1.0f);

        glTexCoord2f(0.0f,1.0f); glVertex3f(-1.0f,yedge,-1.0f);
        glTexCoord2f(0.5f,0.0f); glVertex3f(0.0f,ytop,0.0f);
        glTexCoord2f(1.0f,0.0f); glVertex3f(1.0f,yedge,-1.0f);

        glTexCoord2f(0.0f,1.0f); glVertex3f(1.0f,yedge,-1.0f);
        glTexCoord2f(0.5f,0.0f); glVertex3f(0.0f,ytop,0.0f);
        glTexCoord2f(1.0f,0.0f); glVertex3f(1.0f,yedge,1.0f);
    }
#endif
	glEnd();

	if (itrans == 0) {
		xrot+=0.3f;
		yrot+=0.2f;
		zrot+=0.4f;
	}
 
}
void ptc_gl_toggle_fs();
int ptc_gl_close();

static GLvoid KillGLWindow(GLvoid)								// Properly Kill The Window
{
	if (fullscreen)										// Are We In Fullscreen Mode?
	{
		ChangeDisplaySettings(NULL,0);					// If So Switch Back To The Desktop
		ShowCursor(TRUE);								// Show Mouse Pointer
	} else {
		if (oldsz.cx != 0) {
			ptc_gl_toggle_fs();
		}
	}

	if (hRC)											// Do We Have A Rendering Context?
	{
		if (!wglMakeCurrent(NULL,NULL))					// Are We Able To Release The DC And RC Contexts?
		{
//			MessageBox(NULL,"Release Of DC And RC Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		}

		if (!wglDeleteContext(hRC))						// Are We Able To Delete The RC?
		{
//			MessageBox(NULL,"Release Rendering Context Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		}
		hRC=NULL;										// Set RC To NULL
	}

	if (hDC && !ReleaseDC(hWnd,hDC))					// Are We Able To Release The DC
	{
//		MessageBox(NULL,"Release Device Context Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		hDC=NULL;										// Set DC To NULL
	}

	if (hwndSet) goto post_kill_win;
	if (hWnd) {
		if (got_destroyed == 0) {
			if (!DestroyWindow(hWnd))					// Are We Able To Destroy The Window?
			{
//			MessageBox(NULL,"Could Not Release hWnd.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
			}
		}
	}

	if (!UnregisterClass("OpenGL_Goom",hInstance))			// Are We Able To Unregister Class
	{
//		MessageBox(NULL,"Could Not Unregister Class.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		if (hWnd) DestroyWindow(hWnd);
		if (!UnregisterClass("OpenGL_Goom",hInstance)) {
			OutputDebugString("ReUnregister failed OpenGL Goom\n");
		}
		hInstance=NULL;									// Set hInstance To NULL
	}
	hWnd=NULL;

post_kill_win:
	hwndSet = FALSE;
	/*
	if (TextureImage[0])									// If Texture Exists
	{
		if (TextureImage[0]->data)							// If Texture Image Exists
		{
			free(TextureImage[0]->data);					// Free The Texture Image Memory
		}

		free(TextureImage[0]);								// Free The Image Structure
	}
	*/
}

/*	This Code Creates Our OpenGL Window.  Parameters Are:					*
 *	title			- Title To Appear At The Top Of The Window				*
 *	width			- Width Of The GL Window Or Fullscreen Mode				*
 *	height			- Height Of The GL Window Or Fullscreen Mode			*
 *	bits			- Number Of Bits To Use For Color (8/16/24/32)			*
 *	fullscreenflag	- Use Fullscreen Mode (TRUE) Or Windowed Mode (FALSE)	*/
 
	static	PIXELFORMATDESCRIPTOR pfd=				// pfd Tells Windows How We Want Things To Be
	{
		sizeof(PIXELFORMATDESCRIPTOR),				// Size Of This Pixel Format Descriptor
		1,											// Version Number
		PFD_DRAW_TO_WINDOW |						// Format Must Support Window
		PFD_SUPPORT_OPENGL |						// Format Must Support OpenGL
		PFD_DOUBLEBUFFER,							// Must Support Double Buffering
		PFD_TYPE_RGBA,								// Request An RGBA Format
		0,										// Select Our Color Depth
		0, 0, 0, 0, 0, 0,							// Color Bits Ignored
		0,											// No Alpha Buffer
		0,											// Shift Bit Ignored
		0,											// No Accumulation Buffer
		0, 0, 0, 0,									// Accumulation Bits Ignored
		16,											// 16Bit Z-Buffer (Depth Buffer)  
		0,											// No Stencil Buffer
		0,											// No Auxiliary Buffer
		PFD_MAIN_PLANE,								// Main Drawing Layer
		0,											// Reserved
		0, 0, 0										// Layer Masks Ignored
	};

int ptc_gl_set_parent(HWND hWnd, HINSTANCE hInst)
{
	parwnd = hWnd;
	parinst = hInst;
	return 1;
}

int ptc_gl_open(char* title, int width, int height)
{
	GLuint		PixelFormat;			// Holds The Results After Searching For A Match
	WNDCLASS	wc;						// Windows Class Structure
	DWORD		dwExStyle;				// Window Extended Style
	DWORD		dwStyle;				// Window Style
	HDC			hdctmp;
	RECT		WindowRect;				// Grabs Rectangle Upper Left / Lower Right Values
	int bits = 16;
	WindowRect.left=(long)0;			// Set Left Value To 0
	WindowRect.right=(long)width;		// Set Right Value To Requested Width
	WindowRect.top=(long)0;				// Set Top Value To 0
	WindowRect.bottom=(long)height;		// Set Bottom Value To Requested Height

#ifdef __PTC_WINDOWED__
	fullscreen=FALSE;
#else
	fullscreen=TRUE;
#endif
	surface_width = 256;
	surface_height = 256;
	got_destroyed = 0;

	if (hwndSet) goto post_create_win;

#ifndef VIS_GOOM
	if (parwnd == NULL) {
		hInstance			= GetModuleHandle(NULL);				// Grab An Instance For Our Window
	} else {
		hInstance = parinst;
	}
#else
	hInstance			= init_mod->hDllInstance;
#endif
	wc.style			= CS_HREDRAW | CS_VREDRAW | CS_OWNDC;	// Redraw On Size, And Own DC For Window.
	wc.lpfnWndProc		= (WNDPROC) WndProc;					// WndProc Handles Messages
	wc.cbClsExtra		= 0;									// No Extra Window Data
	wc.cbWndExtra		= 0;									// No Extra Window Data
	wc.hInstance		= hInstance;							// Set The Instance
	wc.hIcon			= LoadIcon(NULL, IDI_WINLOGO);			// Load The Default Icon
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);			// Load The Arrow Pointer
	wc.hbrBackground	= NULL;									// No Background Required For GL
	wc.lpszMenuName		= NULL;									// We Don't Want A Menu
	wc.lpszClassName	= "OpenGL_Goom";							// Set The Class Name

	if (!RegisterClass(&wc))									// Attempt To Register The Window Class
	{
//		MessageBox(NULL,"Failed To Register The Window Class.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;											// Return FALSE
	}
	
	if (fullscreen)												// Attempt Fullscreen Mode?
	{
		DEVMODE dmScreenSettings;								// Device Mode
		memset(&dmScreenSettings,0,sizeof(dmScreenSettings));	// Makes Sure Memory's Cleared
		dmScreenSettings.dmSize=sizeof(dmScreenSettings);		// Size Of The Devmode Structure
		dmScreenSettings.dmPelsWidth	= width;				// Selected Screen Width
		dmScreenSettings.dmPelsHeight	= height;				// Selected Screen Height
		dmScreenSettings.dmBitsPerPel	= bits;					// Selected Bits Per Pixel
		dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;

		// Try To Set Selected Mode And Get Results.  NOTE: CDS_FULLSCREEN Gets Rid Of Start Bar.
		if (ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL)
		{
			// If The Mode Fails, Offer Two Options.  Quit Or Use Windowed Mode.
//			if (MessageBox(NULL,"The Requested Fullscreen Mode Is Not Supported By\nYour Video Card. Use Windowed Mode Instead?","NeHe GL",MB_YESNO|MB_ICONEXCLAMATION)==IDYES)
//			{
//				fullscreen=FALSE;		// Windowed Mode Selected.  Fullscreen = FALSE
//			}
//			else
//			{
//				// Pop Up A Message Box Letting User Know The Program Is Closing.
//				MessageBox(NULL,"Program Will Now Close.","ERROR",MB_OK|MB_ICONSTOP);
				return FALSE;									// Return FALSE
//			}
		}
	}

	if (fullscreen)												// Are We Still In Fullscreen Mode?
	{
		dwExStyle=WS_EX_APPWINDOW;								// Window Extended Style
		dwStyle=WS_POPUP;										// Windows Style
		ShowCursor(FALSE);										// Hide Mouse Pointer
	}
	else
	{
		if (parwnd == NULL) {
			dwExStyle=WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;			// Window Extended Style
			dwStyle=WS_OVERLAPPEDWINDOW | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;							// Windows Style
		} else {
			dwExStyle=WS_EX_NOPARENTNOTIFY;
			dwStyle = WS_CHILD | WS_VISIBLE;
		}
	}

	AdjustWindowRectEx(&WindowRect, dwStyle, FALSE, dwExStyle);		// Adjust Window To True Requested Size


	// Create The Window
	if (!(hWnd=CreateWindowEx(	dwExStyle,							// Extended Style For The Window
								"OpenGL_Goom",							// Class Name
								title,								// Window Title
								dwStyle,					// Required Window Style
								0, 0,								// Window Position
								WindowRect.right-WindowRect.left,	// Calculate Window Width
								WindowRect.bottom-WindowRect.top,	// Calculate Window Height
#ifndef VIS_GOOM
								parwnd,								// No Parent Window
#else
								init_mod->hwndParent,								// No Parent Window
#endif
								NULL,								// No Menu
								hInstance,							// Instance
								NULL)))								// Dont Pass Anything To WM_CREATE
	{
		KillGLWindow();								// Reset The Display
//		MessageBox(NULL,"Window Creation Error.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}
post_create_win:
#ifdef VIS_GOOM
	SetWindowLong(hWnd,GWL_USERDATA,(LONG)init_mod); // set our user data to a "this" pointer
#endif

	hdctmp = GetDC(hWnd);
	pfd.cColorBits = GetDeviceCaps(hdctmp,BITSPIXEL);
	ReleaseDC(hWnd,hdctmp);

	if (!(hDC=GetDC(hWnd)))							// Did We Get A Device Context?
	{
		KillGLWindow();								// Reset The Display
//		MessageBox(NULL,"Can't Create A GL Device Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if (!(PixelFormat=ChoosePixelFormat(hDC,&pfd)))	// Did Windows Find A Matching Pixel Format?
	{
		KillGLWindow();								// Reset The Display
//		MessageBox(NULL,"Can't Find A Suitable PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if(!SetPixelFormat(hDC,PixelFormat,&pfd))		// Are We Able To Set The Pixel Format?
	{
		KillGLWindow();								// Reset The Display
//		MessageBox(NULL,"Can't Set The PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if (!(hRC=wglCreateContext(hDC)))				// Are We Able To Get A Rendering Context?
	{
		KillGLWindow();								// Reset The Display
//		MessageBox(NULL,"Can't Create A GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if(!wglMakeCurrent(hDC,hRC))					// Try To Activate The Rendering Context
	{
		KillGLWindow();								// Reset The Display
//		MessageBox(NULL,"Can't Activate The GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}
	oldsz.cx=0;
#ifdef __PTC_RESIZE_WINDOW__
#ifdef __PTC_SYSTEM_MENU__

    // add entry to system menu to restore original window size
    system_menu = GetSystemMenu(hWnd,FALSE);
	if (system_menu  != NULL) {
	    AppendMenu(system_menu, MF_STRING, SC_ZOOM_1x1, "Zoom 1 x 1");
		AppendMenu(system_menu, MF_STRING, SC_ZOOM_2x2, "Zoom 2 x 2");
		AppendMenu(system_menu, MF_STRING, SC_ZOOM_4x4, "Zoom 4 x 4");
	}

    original_window_width = width;
    original_window_height = height;

#endif
#endif

	ShowWindow(hWnd,SW_SHOW);						// Show The Window
	SetForegroundWindow(hWnd);						// Slightly Higher Priority
	SetFocus(hWnd);									// Sets Keyboard Focus To The Window
	if (!hwndSet) {
		ReSizeGLScene(width, height);					// Set Up Our Perspective GL Screen
	} else {
		RECT rc;
		GetClientRect(hWnd,&rc);
#ifndef SCREENSAVBUILD
		ReSizeGLScene(rc.right-rc.left,rc.bottom-rc.top);
#else
		if ((rc.right - rc.left) >= (3*GetSystemMetrics(SM_CXSCREEN))/4) {
			// don't switch modes if previewing!!!
			ptc_gl_toggle_fs();
		}
#endif
	}

	if (!InitGL(surface_width,surface_height))									// Initialize Our Newly Created GL Window
	{
		KillGLWindow();								// Reset The Display
//		MessageBox(NULL,"Initialization Failed.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	return TRUE;									// Success
}

#if 0
static LRESULT CALLBACK WndProc(	HWND	hWnd,			// Handle For This Window
							UINT	uMsg,			// Message For This Window
							WPARAM	wParam,			// Additional Message Information
							LPARAM	lParam)			// Additional Message Information
{
	switch (uMsg)									// Check For Windows Messages
	{
		case WM_ACTIVATE:							// Watch For Window Activate Message
		{
			if (!HIWORD(wParam))					// Check Minimization State
			{
				active=TRUE;						// Program Is Active
			}
			else
			{
				active=FALSE;						// Program Is No Longer Active
			}

			return 0;								// Return To The Message Loop
		}

		case WM_SYSCOMMAND:							// Intercept System Commands
		{
			switch (wParam)							// Check System Calls
			{
				case SC_SCREENSAVE:					// Screensaver Trying To Start?
				case SC_MONITORPOWER:				// Monitor Trying To Enter Powersave?
				return 0;							// Prevent From Happening
			}
			break;									// Exit
		}

		case WM_CLOSE:								// Did We Receive A Close Message?
		{
//			PostQuitMessage(0);						// Send A Quit Message
			ptc_close();
			ExitProcess(0);
			return 0;								// Jump Back
		}

		case WM_KEYDOWN:							// Is A Key Being Held Down?
		{
			keys[wParam] = TRUE;					// If So, Mark It As TRUE
			return 0;								// Jump Back
		}

		case WM_KEYUP:								// Has A Key Been Released?
		{
			keys[wParam] = FALSE;					// If So, Mark It As FALSE
			return 0;								// Jump Back
		}

		case WM_SIZE:								// Resize The OpenGL Window
		{
			ReSizeGLScene(LOWORD(lParam),HIWORD(lParam));  // LoWord=Width, HiWord=Height
			return 0;								// Jump Back
		}
	}

	// Pass All Unhandled Messages To DefWindowProc
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}
#endif

void ptc_gl_toggle_fs()
{
	static int fs_ok = 0;
#ifndef __PTC_WINDOWED__
	return; /* no going back now */
#else
	RECT r;
	DWORD dwStyle;
	HWND hWnd1 = hWnd;
	if (fullscreen) return;
	if (oldsz.cx == 0) {
		DEVMODE dmScreenSettings;								// Device Mode
		memset(&dmScreenSettings,0,sizeof(dmScreenSettings));	// Makes Sure Memory's Cleared
		dmScreenSettings.dmSize=sizeof(dmScreenSettings);		// Size Of The Devmode Structure
		dmScreenSettings.dmPelsWidth	= 640;				// Selected Screen Width
		dmScreenSettings.dmPelsHeight	= 480;				// Selected Screen Height
//		dmScreenSettings.dmBitsPerPel	= bits;					// Selected Bits Per Pixel
//		dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;
		dmScreenSettings.dmFields=DM_PELSWIDTH|DM_PELSHEIGHT;

		GetWindowRect(hWnd,&r);
		oldpt.x = r.left;
		oldpt.y = r.top;
		oldsz.cx=r.right-r.left;
		oldsz.cy=r.bottom-r.top;
		dwStyle = GetWindowLong(hWnd,GWL_STYLE);
		// Try To Set Selected Mode And Get Results.  NOTE: CDS_FULLSCREEN Gets Rid Of Start Bar.
		dwStyle = dwStyle & ~(WS_CAPTION | WS_SYSMENU | WS_THICKFRAME);
		SetWindowLong(hWnd,GWL_STYLE,dwStyle);
//		dwStyle = GetWindowLong(hWnd,GWL_EXSTYLE);
//		dwStyle = dwStyle & ~(WS_EX_WINDOWEDGE);
//		SetWindowLong(hWnd,GWL_EXSTYLE,dwStyle);
		if (ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL)
		{
			fs_ok = 0;
			SetWindowPos(hWnd,0,0,0,
				GetSystemMetrics(SM_CXSCREEN),
				GetSystemMetrics(SM_CYSCREEN),SWP_NOACTIVATE | SWP_NOZORDER);
			ReSizeGLScene(GetSystemMetrics(SM_CXSCREEN),GetSystemMetrics(SM_CYSCREEN));
		} else {
			fs_ok = 1;
			SetWindowPos(hWnd,0,0,0,
				640,
				480,SWP_NOACTIVATE | SWP_NOZORDER);
			ReSizeGLScene(640,480);
			ShowCursor(FALSE);
		}
	} else {
		dwStyle = GetWindowLong(hWnd,GWL_STYLE);
		if (fs_ok) {
			ChangeDisplaySettings(NULL,0);
			ShowCursor(TRUE);
		} else {
		}
		dwStyle = dwStyle | (WS_CAPTION | WS_SYSMENU | WS_THICKFRAME);
		SetWindowLong(hWnd,GWL_STYLE,dwStyle);
//		dwStyle = GetWindowLong(hWnd,GWL_EXSTYLE);
//		dwStyle = dwStyle | (WS_EX_WINDOWEDGE);
//		SetWindowLong(hWnd,GWL_EXSTYLE,dwStyle);
		SetWindowPos(hWnd,0,oldpt.x,oldpt.y,
			oldsz.cx,
			oldsz.cy,SWP_NOACTIVATE | SWP_NOZORDER);
		ReSizeGLScene(oldsz.cx,oldsz.cy);
		oldsz.cx=0;
		oldsz.cy=0;
	}
#endif
}


static LRESULT CALLBACK WndProc(HWND hWnd_in,UINT message,WPARAM wParam,LPARAM lParam)
{
    // result data
    int result = 0;
#ifdef VIS_GOOM
	winampVisModule *this_mod;
	visGoomData *vg;
#endif

    // handle message
    switch (message)
    {
        #ifdef __PTC_WINDOWED__

        case WM_PAINT:
        {
            // paint primary
//            DrawGLScene(cache_buffer);

            // call default window painting
            return DefWindowProc(hWnd_in,message,wParam,lParam);
        }
        break;

        #else

        case WM_ACTIVATEAPP:
        {                                       
            // update active flag
            active = (BOOL) wParam;
        }
        break;

        case WM_SETCURSOR:
        {
            // hide cursor
            SetCursor(0);
        }
        break;

        #endif


#ifdef __PTC_WINDOWED__
#ifdef __PTC_RESIZE_WINDOW__
#ifdef __PTC_SYSTEM_MENU__

		// check for message from our system menu entry
		case WM_SYSCOMMAND:
		{
			if ((wParam&0xFFFFFFF0)==SC_ZOOM_MSK)
            {
                #ifdef __PTC_CENTER_WINDOW__
                    int zoom = wParam & 0x7;
                    int x = (GetSystemMetrics(SM_CXSCREEN) - original_window_width*zoom) >> 1;
                    int y = (GetSystemMetrics(SM_CYSCREEN) - original_window_height*zoom) >> 1;
                    SetWindowPos(hWnd_in, NULL, x, y,original_window_width*zoom, original_window_height*zoom, SWP_NOZORDER);
                #else
                    int zoom = wParam & 0x7;
                    SetWindowPos(hWnd_in, NULL, 0, 0,original_window_width*zoom, original_window_height*zoom, SWP_NOMOVE | SWP_NOZORDER);
                #endif
				ReSizeGLScene(original_window_width*zoom, original_window_height*zoom);
            }
            // pass everything else to the default (this is rather important)
			else return DefWindowProc(hWnd_in, message, wParam, lParam);
		}
#endif
#endif
#endif

#ifdef WMP_GOOM
		case WM_DESTROY:
			OutputDebugString("Got GL WM_DESTROY Message\n");
			got_destroyed=1;
			return 0;
		case WM_SHOWWINDOW:
			if (wParam == TRUE) {
				OutputDebugString("Goom Is GL VISIBLE\n");
			} else {
				OutputDebugString("Goom Is GL HIDDEN\n");
			}
			return 0;
#endif

// add keyboard shortcuts to toggle fullscreen with f or Alt+Enter
#ifdef __PTC_WINDOWED__
#ifndef WMP_GOOM
#ifndef VIS_GOOM
        case WM_KEYUP:
		{
			if (((wParam&0xFF)=='f') || ((wParam&0xFF)=='F')) {
				ptc_gl_toggle_fs();
				return 0;
			}
			if (wParam == VK_ADD) {
				zshift += 1.0f;
			}
			if (wParam == VK_SUBTRACT) {
				zshift -= 1.0f;
			}
			break;
        }
#endif
		case WM_SYSKEYDOWN:
		{
			if (wParam == VK_RETURN) {
				ptc_gl_toggle_fs();
				return 0;
			}
#ifdef VIS_GOOM
			if (oldsz.cx == 0) { // don't open Config dialog when we're full screen
				this_mod = (winampVisModule *) GetWindowLong(hWnd_in,GWL_USERDATA);
				if (wParam != VK_F4) PostMessage(this_mod->hwndParent,message,wParam,lParam);
				return 0;
			}
#else
			break;
#endif
		}
#endif
#endif

#ifdef VIS_GOOM
		case WM_DESTROY:
			return 0;
		case WM_KEYDOWN: // pass keyboard messages to main winamp window (for processing)
		case WM_KEYUP:
			{	// get this_mod from our window's user data
				this_mod = (winampVisModule *) GetWindowLong(hWnd_in,GWL_USERDATA);
				if (message == WM_KEYDOWN && (int)wParam >= VK_F1 && (int)wParam <= VK_F8) {
					vg = (visGoomData *)this_mod->userData;
					vg->forcemode = ((int)wParam - VK_F1 + 1);
				} else {
					PostMessage(this_mod->hwndParent,message,wParam,lParam);
				}
				if (message == WM_KEYUP) {
					if (wParam=='M') {
						vg = (visGoomData *)this_mod->userData;
						vg->ogl = 1-vg->ogl;
					}
					if (wParam == VK_ADD) {
						zshift += 1.0f;
					}
					if (wParam == VK_SUBTRACT) {
						zshift -= 1.0f;
					}
					if (wParam==VK_ESCAPE) {
						vg = (visGoomData *)this_mod->userData;
						vg->encore_switch=-1;
					}
					if (wParam==VK_SPACE) {
						vg = (visGoomData *)this_mod->userData;
						vg->encore_switch=1;
					}
				}
			}
			return 0;
#endif
#ifdef __PTC_CLOSE_ON_ESCAPE__
#if !defined(WMP_GOOM) && !defined(VIS_GOOM)
        case WM_KEYDOWN:
        {
            // close on escape key
            if ((wParam&0xFF)!=27) break;
		}
#endif
#endif


        case WM_CLOSE:
        {
            #ifdef __PTC_ALLOW_CLOSE__

#ifdef VIS_GOOM
				this_mod = (winampVisModule *) GetWindowLong(hWnd_in,GWL_USERDATA);
				vg = (visGoomData *)this_mod->userData;
				vg->iQuitMode = 1;
				vg->bQuit=TRUE;
//				PostQuitMessage(0);
//				PostThreadMessage(vg->waThreadID,WM_QUIT,0,0);
//				this_mod->Quit(this_mod);
				return 0;
#endif
#ifdef WAVEINBUILD
				goom_audio_finish(0);
#endif
			    // close ptc
			    ptc_gl_close();
#ifdef WAVEINBUILD
				goom_audio_finish(1);
#endif

#ifndef WMP_GOOM
			    // exit process
			    ExitProcess(0);
#endif

            #endif
        }
        break;

		case WM_SIZE:
		{
#ifndef WMP_GOOM
			if (wParam != SIZE_MINIMIZED) ReSizeGLScene(LOWORD(lParam),HIWORD(lParam));  // LoWord=Width, HiWord=Height
#endif
#ifdef VIS_GOOM
			this_mod = (winampVisModule *) GetWindowLong(hWnd_in,GWL_USERDATA);
			vg = (visGoomData *)this_mod->userData;
			if (wParam == SIZE_MINIMIZED) {
				vg->spf = 1.0f;
			} else {
				vg->spf = 1.0f/(float)vg->sleeprate;
			}
#endif
		}

        default:
        {
            // unhandled messages
            result = DefWindowProc(hWnd_in,message,wParam,lParam);
        }
    }

    // finished
    return result;
}

int ptc_gl_set_hwnd(void *hWnd1)
{
	if (hWnd != NULL) {
		return 0; /* we have a window already */
	} else {
		hWnd = (HWND)hWnd1;
		hwndSet = TRUE;
	}
	return 1;
}


int ptc_gl_idle_loop()
{
    MSG message;
    while (PeekMessage(&message,hWnd,0,0,PM_REMOVE))
    {
        // translate and dispatch
        TranslateMessage(&message);
        DispatchMessage(&message);
    }
	if (got_destroyed != 0) return 0;
	Sleep(300);
	return 1;
}

int ptc_gl_update(void *buffer)
{
	MSG		msg;									// Windows Message Structure
#ifdef VIS_GOOM
	winampVisModule *this_mod;
	visGoomData *vg;
#endif

		while (PeekMessage(&msg,hWnd,0,0,PM_REMOVE))	// Is There A Message Waiting?
		{
//			if (msg.message==WM_QUIT)				// Have We Received A Quit Message?
//			{
//				done=TRUE;							// If So done=TRUE
//			}
//			else									// If Not, Deal With Window Messages
			{
				TranslateMessage(&msg);				// Translate The Message
				DispatchMessage(&msg);				// Dispatch The Message
			}
		}
		if (got_destroyed != 0) return 0;
			// Draw The Scene.  Watch For ESC Key And Quit Messages From DrawGLScene()
#ifdef VIS_GOOM
	// see if we were closed in this round of dispatching
	this_mod = (winampVisModule *) GetWindowLong(hWnd,GWL_USERDATA);
	vg = (visGoomData *)this_mod->userData;
	if (vg->bQuit) {
		return 1;
	}
#endif

			DrawGLScene(buffer);
			{
				SwapBuffers(hDC);					// Swap Buffers (Double Buffering)
			}

			/*
			if (keys[VK_F1])						// Is F1 Being Pressed?
			{
				keys[VK_F1]=FALSE;					// If So Make Key FALSE
				KillGLWindow();						// Kill Our Current Window
				fullscreen=!fullscreen;				// Toggle Fullscreen / Windowed Mode
				// Recreate Our OpenGL Window
				if (!CreateGLWindow("NeHe's Texture Mapping Tutorial",640,480,16,fullscreen))
				{
					return 0;						// Quit If Window Was Not Created
				}
			}
			*/

		return 1;
}

int ptc_gl_close() 
{
	// Shutdown
	KillGLWindow();									// Kill The Window
	return 1;
}
