/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.Source;

class Cdef
extends Source {
    private String[] strTokens;
    private double[] constants;
    private int[] dsIndices;
    private byte[] tokens;

    Cdef(String string) {
        super(string);
        this.strTokens = new String[0];
    }

    Cdef(String string, String string2) {
        super(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n = stringTokenizer.countTokens();
        this.strTokens = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.strTokens[n2] = stringTokenizer.nextToken().trim();
            ++n2;
        }
    }

    void prepare(HashMap hashMap, int n, int n2) throws RrdException {
        this.values = new double[n];
        this.aggregatePoints = n2;
        this.constants = new double[this.strTokens.length];
        this.dsIndices = new int[this.strTokens.length];
        this.tokens = new byte[this.strTokens.length];
        for (int i = 0; i < this.strTokens.length; ++i) {
            String string = this.strTokens[i];
            if (this.isNumber(string)) {
                this.tokens[i] = 0;
                this.constants[i] = Double.parseDouble(string);
                continue;
            }
            if (hashMap.containsKey(string)) {
                this.tokens[i] = 1;
                this.dsIndices[i] = (Integer)hashMap.get(string);
                continue;
            }
            if (string.equals("+")) {
                this.tokens[i] = 2;
                continue;
            }
            if (string.equals("-")) {
                this.tokens[i] = 3;
                continue;
            }
            if (string.equals("*")) {
                this.tokens[i] = 4;
                continue;
            }
            if (string.equals("/")) {
                this.tokens[i] = 5;
                continue;
            }
            if (string.equals("%")) {
                this.tokens[i] = 6;
                continue;
            }
            if (string.equals("SIN")) {
                this.tokens[i] = 7;
                continue;
            }
            if (string.equals("COS")) {
                this.tokens[i] = 8;
                continue;
            }
            if (string.equals("LOG")) {
                this.tokens[i] = 9;
                continue;
            }
            if (string.equals("EXP")) {
                this.tokens[i] = 10;
                continue;
            }
            if (string.equals("FLOOR")) {
                this.tokens[i] = 11;
                continue;
            }
            if (string.equals("CEIL")) {
                this.tokens[i] = 12;
                continue;
            }
            if (string.equals("ROUND")) {
                this.tokens[i] = 13;
                continue;
            }
            if (string.equals("POW")) {
                this.tokens[i] = 14;
                continue;
            }
            if (string.equals("ABS")) {
                this.tokens[i] = 15;
                continue;
            }
            if (string.equals("SQRT")) {
                this.tokens[i] = 16;
                continue;
            }
            if (string.equals("RANDOM")) {
                this.tokens[i] = 17;
                continue;
            }
            if (string.equals("LT")) {
                this.tokens[i] = 18;
                continue;
            }
            if (string.equals("LE")) {
                this.tokens[i] = 19;
                continue;
            }
            if (string.equals("GT")) {
                this.tokens[i] = 20;
                continue;
            }
            if (string.equals("GE")) {
                this.tokens[i] = 21;
                continue;
            }
            if (string.equals("EQ")) {
                this.tokens[i] = 22;
                continue;
            }
            if (string.equals("IF")) {
                this.tokens[i] = 23;
                continue;
            }
            if (string.equals("MIN")) {
                this.tokens[i] = 24;
                continue;
            }
            if (string.equals("MAX")) {
                this.tokens[i] = 25;
                continue;
            }
            if (string.equals("LIMIT")) {
                this.tokens[i] = 26;
                continue;
            }
            if (string.equals("DUP")) {
                this.tokens[i] = 27;
                continue;
            }
            if (string.equals("EXC")) {
                this.tokens[i] = 28;
                continue;
            }
            if (string.equals("POP")) {
                this.tokens[i] = 29;
                continue;
            }
            if (string.equals("UN")) {
                this.tokens[i] = 30;
                continue;
            }
            if (string.equals("UNKN")) {
                this.tokens[i] = 31;
                continue;
            }
            if (string.equals("NOW")) {
                this.tokens[i] = 32;
                continue;
            }
            if (string.equals("TIME")) {
                this.tokens[i] = 33;
                continue;
            }
            if (string.equals("PI")) {
                this.tokens[i] = 34;
                continue;
            }
            if (string.equals("E")) {
                this.tokens[i] = 35;
                continue;
            }
            if (string.equals("AND")) {
                this.tokens[i] = 36;
                continue;
            }
            if (string.equals("OR")) {
                this.tokens[i] = 37;
                continue;
            }
            if (string.equals("XOR")) {
                this.tokens[i] = 38;
                continue;
            }
            if (string.equals("SAMPLES")) {
                this.tokens[i] = 39;
                continue;
            }
            if (string.equals("STEP")) {
                this.tokens[i] = 40;
                continue;
            }
            throw new RrdException("Unknown token encountered: " + string);
        }
    }

    int calculateLevel(int[] nArray) {
        int n = 0;
        for (int i = 0; i < this.dsIndices.length; ++i) {
            if (nArray[this.dsIndices[i]] <= n) continue;
            n = nArray[this.dsIndices[i]];
        }
        return n;
    }

    void set(int n, long l, double d) {
        super.set(n, l, d);
        this.values[n] = d;
    }

    byte[] getTokens() {
        return this.tokens;
    }

    double[] getConstants() {
        return this.constants;
    }

    int[] getDsIndices() {
        return this.dsIndices;
    }

    String getRpnString() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.strTokens.length - 1; ++i) {
            stringBuffer.append(this.strTokens[i]);
            stringBuffer.append(',');
        }
        if (this.strTokens.length > 0) {
            stringBuffer.append(this.strTokens[this.strTokens.length - 1]);
        }
        return stringBuffer.toString();
    }

    private boolean isNumber(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    void exportXml(XmlWriter xmlWriter) {
        xmlWriter.startTag("def");
        xmlWriter.writeTag("name", this.getName());
        xmlWriter.writeTag("rpn", this.getRpnString());
        xmlWriter.closeTag();
    }
}

