/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.ChartGraphics;
import org.jrobin.graph.PlotDef;
import org.jrobin.graph.Source;

class Line
extends PlotDef {
    protected static BasicStroke DEF_LINE_STROKE = new BasicStroke(1.0f);
    protected int lineWidth = 1;

    Line() {
    }

    Line(String string, Color color) {
        super(string, color);
    }

    Line(String string, Color color, int n) {
        this(string, color);
        this.lineWidth = n;
    }

    Line(Source source, double[] dArray, Color color, boolean bl, boolean bl2) {
        super(source, dArray, color, bl, bl2);
    }

    void draw(ChartGraphics chartGraphics, int[] nArray, double[] dArray, int n) throws RrdException {
        chartGraphics.setColor(this.color);
        chartGraphics.setStroke(this.lineWidth != 1 ? new BasicStroke(this.lineWidth) : DEF_LINE_STROKE);
        Graphics2D graphics2D = chartGraphics.getGraphics();
        int n2 = this.values.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            double d = this.values[i];
            n5 = nArray[i];
            if (this.stacked) {
                d += dArray[i];
            }
            n6 = chartGraphics.getY(d);
            if (this.visible && n5 != 0 && n4 != Integer.MIN_VALUE && n6 != Integer.MIN_VALUE) {
                graphics2D.drawLine(n3, -n4, n5, -n6);
            }
            dArray[i] = d;
            n3 = n5;
            n4 = n6;
        }
        chartGraphics.setStroke(STROKE);
    }

    int getLineWidth() {
        return this.lineWidth;
    }

    void exportXmlTemplate(XmlWriter xmlWriter, String string) {
        xmlWriter.startTag("line");
        xmlWriter.writeTag("datasource", this.sourceName);
        xmlWriter.writeTag("color", this.color);
        xmlWriter.writeTag("legend", string);
        xmlWriter.writeTag("width", this.lineWidth);
        xmlWriter.closeTag();
    }
}

