/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

class ValueFormatter {
    protected static final int NO_SCALE = -1;
    protected static final double DEFAULT_BASE = 1000.0;
    private double base = 1000.0;
    private double[] scaleValues = new double[]{1.0E18, 1.0E15, 1.0E12, 1.0E9, 1000000.0, 1000.0, 1.0, 0.001, 1.0E-6, 1.0E-9, 1.0E-12, 1.0E-15};
    protected static String[] PREFIXES = new String[]{"E", "P", "T", "G", "M", "k", " ", "m", "\u00b5", "n", "p", "f"};
    private double value;
    private DecimalFormat decFormat;
    private int formattedStrLen;
    private double scaledValue;
    private int scaleIndex = -1;
    private int fixedIndex = -1;
    private String prefix;
    private boolean scale = false;

    ValueFormatter() {
    }

    ValueFormatter(double d, int n) {
        this.setBase(d);
        this.fixedIndex = n;
    }

    void setFormat(double d, int n, int n2) {
        this.value = d;
        this.decFormat = this.getDecimalFormat(n);
        this.formattedStrLen = n2;
    }

    void setScaling(boolean bl, boolean bl2) {
        if (!bl2) {
            this.scaleIndex = -1;
        }
        if (this.fixedIndex >= 0) {
            this.scale = true;
            this.scaleIndex = this.fixedIndex;
        } else {
            this.scale = bl || bl2;
        }
    }

    String getFormattedValue() {
        String string = "" + this.value;
        if (!Double.isNaN(this.value)) {
            if (this.scale) {
                this.scaleValue(this.scaleIndex);
                string = this.decFormat.format(this.scaledValue);
            } else {
                string = this.decFormat.format(this.value);
            }
        }
        int n = this.formattedStrLen - string.length();
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        string = stringBuffer.append(string).toString();
        return string;
    }

    String getScaledValue() {
        int n = this.scaleIndex;
        this.scaleValue(n);
        long l = new Double(this.scaledValue).longValue();
        this.scaleIndex = n;
        if ((double)l == this.scaledValue) {
            return "" + l;
        }
        return "" + this.scaledValue;
    }

    void setBase(double d) {
        int n;
        if (d == this.base) {
            return;
        }
        this.base = d;
        double d2 = 1.0;
        for (n = 1; n < 7; ++n) {
            this.scaleValues[6 - n] = d2 *= d;
        }
        d2 = 1.0;
        for (n = 7; n < this.scaleValues.length; ++n) {
            this.scaleValues[n] = 1.0 / (d2 *= d);
        }
    }

    double getBase() {
        return this.base;
    }

    String getPrefix() {
        return this.prefix;
    }

    private void scaleValue(int n) {
        double d = Math.abs(this.value);
        if (n == -1) {
            this.prefix = " ";
            this.scaledValue = this.value;
            for (int i = 0; i < this.scaleValues.length; ++i) {
                if (!(d >= this.scaleValues[i]) || !(d < this.scaleValues[i] * this.base) || this.scaleValues[i] == 0.001) continue;
                this.prefix = PREFIXES[i];
                this.scaledValue = this.value / this.scaleValues[i];
                this.scaleIndex = i;
                return;
            }
        } else {
            this.prefix = PREFIXES[n];
            this.scaledValue = this.value / this.scaleValues[n];
            this.scaleIndex = n;
        }
    }

    private DecimalFormat getDecimalFormat(int n) {
        StringBuffer stringBuffer = new StringBuffer("###0");
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append('0');
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        decimalFormat.applyPattern(stringBuffer.toString());
        return decimalFormat;
    }
}

