/*******************************************************************************
* filechannel.cpp: file channel
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: filechannel.cpp,v 1.4 2002/08/09 13:42:32 tooney Exp $
*
* Authors: James Courtier-Dutton <James@superbug.demon.co.uk>
*          Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


//------------------------------------------------------------------------------
// Preamble
//------------------------------------------------------------------------------
#include "../../core/defs.h"

#include "../../core/core.h"
#include "../../mpeg/mpeg.h"
#include "../../mpeg/ts.h"
#include "../../mpeg/rtp.h"
#include "../../server/buffer.h"
#include "../../server/output.h"
#include "../../server/channel.h"

#include "fileoutput.h"
#include "filechannel.h"


//------------------------------------------------------------------------------
// Library declaration
//------------------------------------------------------------------------------
#ifdef __PLUGIN__
GENERATE_LIB_ARGS(C_FileChannelModule, handle);
#endif


//------------------------------------------------------------------------------
// Builtin declaration
//------------------------------------------------------------------------------
#ifdef __BUILTIN__
C_Module* NewBuiltin_filechannel(handle hLog)
{
  return new C_FileChannelModule(hLog);
}
#endif


//******************************************************************************
// class C_FileChannel
//******************************************************************************
//
//******************************************************************************

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_FileChannel::C_FileChannel(C_Module* pModule,
                             const C_String& strName) : C_Channel(pModule,
                                                                  strName)
{
  C_Application* pApp = C_Application::GetApp();
  ASSERT(pApp);

  C_String strFilename = pApp->GetSetting(m_strName+".FileName", "fileout.ts");
  C_String strAppend  = pApp->GetSetting(m_strName+".Append", "No");

  bool bAppend;

  if(strAppend.ToLower() == "yes")
    bAppend = true;
  else
    bAppend = false;

  m_pOutput = new C_FileOutput(strFilename, bAppend);
}


